/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import swim.streamlet.Inlet;
import swim.streamlet.Outlet;

public abstract class AbstractInlet<I>
implements Inlet<I> {
    protected Outlet<? extends I> input = null;
    protected int version = -1;

    @Override
    public Outlet<? extends I> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends I> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        Outlet<I> input = this.input;
        if (input != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public void disconnectOutputs() {
    }

    @Override
    public void invalidateOutput() {
        if (this.version >= 0) {
            this.willInvalidateOutput();
            this.version = -1;
            this.onInvalidateOutput();
            this.didInvalidateOutput();
        }
    }

    @Override
    public void reconcileOutput(int version) {
        if (this.version < 0) {
            this.willReconcileOutput(version);
            this.version = version;
            if (this.input != null) {
                this.input.reconcileInput(version);
            }
            this.onReconcileOutput(version);
            this.didReconcileOutput(version);
        }
    }

    protected void willInvalidateOutput() {
    }

    protected void onInvalidateOutput() {
    }

    protected void didInvalidateOutput() {
    }

    protected void willReconcileOutput(int version) {
    }

    protected void onReconcileOutput(int version) {
    }

    protected void didReconcileOutput(int version) {
    }
}

