/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import swim.math.R2ToZ2Operator;
import swim.math.Z2ToR2Operator;
import swim.spatial.GeoProjection;

final class WGS84Inverse
implements Z2ToR2Operator {
    WGS84Inverse() {
    }

    public double transformX(long x, long y) {
        return WGS84Inverse.transformX(x);
    }

    public double transformY(long x, long y) {
        return WGS84Inverse.transformY(y);
    }

    public R2ToZ2Operator inverse() {
        return GeoProjection.wgs84();
    }

    static double transformX(long x) {
        return WGS84Inverse.round((double)x / 9.223372036854776E18 * 360.0 - 180.0);
    }

    static double transformY(long y) {
        return WGS84Inverse.round((double)y / 9.223372036854776E18 * 180.0 - 90.0);
    }

    static double round(double value) {
        return (double)Math.round(value * 1.0E8) / 1.0E8;
    }
}

