/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.codec.Decoder;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpModem;
import swim.io.IpModemContext;
import swim.io.IpSocket;
import swim.io.http.HttpResponder;
import swim.io.http.HttpServer;
import swim.io.http.HttpServerContext;
import swim.io.http.HttpServerResponder;
import swim.io.http.HttpSettings;

public class HttpServerModem
implements IpModem<HttpRequest<?>, HttpResponse<?>>,
HttpServerContext {
    protected final HttpServer server;
    protected final HttpSettings httpSettings;
    volatile HttpServerResponder<?> requesting;
    volatile FingerTrieSeq<HttpServerResponder<?>> responders;
    protected IpModemContext<HttpRequest<?>, HttpResponse<?>> context;
    static final AtomicReferenceFieldUpdater<HttpServerModem, HttpServerResponder<?>> REQUESTING = AtomicReferenceFieldUpdater.newUpdater(HttpServerModem.class, HttpServerResponder.class, "requesting");
    static final AtomicReferenceFieldUpdater<HttpServerModem, FingerTrieSeq<HttpServerResponder<?>>> RESPONDERS = AtomicReferenceFieldUpdater.newUpdater(HttpServerModem.class, FingerTrieSeq.class, "responders");

    public HttpServerModem(HttpServer server, HttpSettings httpSettings) {
        this.server = server;
        this.httpSettings = httpSettings;
        this.responders = FingerTrieSeq.empty();
    }

    public IpModemContext<HttpRequest<?>, HttpResponse<?>> ipModemContext() {
        return this.context;
    }

    public void setIpModemContext(IpModemContext<HttpRequest<?>, HttpResponse<?>> context) {
        this.context = context;
        this.server.setHttpServerContext(this);
    }

    public long idleTimeout() {
        return this.server.idleTimeout();
    }

    public void doRead() {
    }

    public void didRead(HttpRequest<?> request) {
        if (REQUESTING.get(this) == null) {
            this.willRequest(request);
        } else {
            this.didRequest(request);
        }
    }

    public void doWrite() {
    }

    public void didWrite(HttpResponse<?> response) {
        this.didRespond(response);
    }

    public void willConnect() {
    }

    public void didConnect() {
        this.server.didConnect();
    }

    public void willSecure() {
        this.server.willSecure();
    }

    public void didSecure() {
        this.server.didSecure();
    }

    public void willBecome(IpSocket socket) {
        this.server.willBecome(socket);
    }

    public void didBecome(IpSocket socket) {
        this.server.didBecome(socket);
    }

    public void didTimeout() {
        for (HttpServerResponder responderContext : RESPONDERS.get(this)) {
            responderContext.didTimeout();
        }
        this.server.didTimeout();
    }

    public void didDisconnect() {
        FingerTrieSeq newResponders;
        FingerTrieSeq<HttpServerResponder<?>> oldResponders;
        while ((oldResponders = RESPONDERS.get(this)) != (newResponders = FingerTrieSeq.empty())) {
            if (!RESPONDERS.compareAndSet(this, oldResponders, newResponders)) continue;
            for (HttpServerResponder responderContext : oldResponders) {
                responderContext.didDisconnect();
            }
        }
        this.server.didDisconnect();
        this.close();
    }

    public void didFail(Throwable error) {
        FingerTrieSeq newResponders;
        FingerTrieSeq<HttpServerResponder<?>> oldResponders;
        while ((oldResponders = RESPONDERS.get(this)) != (newResponders = FingerTrieSeq.empty())) {
            if (!RESPONDERS.compareAndSet(this, oldResponders, newResponders)) continue;
            for (HttpServerResponder responderContext : oldResponders) {
                responderContext.didFail(error);
            }
        }
        this.server.didFail(error);
        this.close();
    }

    public boolean isConnected() {
        IpModemContext<HttpRequest<?>, HttpResponse<?>> context = this.context;
        return context != null && context.isConnected();
    }

    public boolean isClient() {
        return false;
    }

    public boolean isServer() {
        return true;
    }

    public boolean isSecure() {
        IpModemContext<HttpRequest<?>, HttpResponse<?>> context = this.context;
        return context != null && context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public HttpSettings httpSettings() {
        return this.httpSettings;
    }

    @Override
    public void readRequest() {
        this.doReadRequestMessage();
    }

    @Override
    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    @Override
    public void close() {
        this.context.close();
    }

    void doReadRequestMessage() {
        this.context.read((Decoder)Utf8.decodedParser((Parser)Http.standardParser().requestParser()));
    }

    void doReadRequestEntity(Decoder<HttpRequest<?>> entityDecoder) {
        if (entityDecoder.isCont()) {
            this.context.read(entityDecoder);
        } else {
            this.didRead((HttpRequest)entityDecoder.bind());
        }
    }

    void willRequest(HttpRequest<?> request) {
        block2: {
            FingerTrieSeq newResponders;
            FingerTrieSeq<HttpServerResponder<?>> oldResponders;
            HttpResponder<?> responder = this.server.doRequest(request);
            HttpServerResponder responderContext = new HttpServerResponder(this, responder);
            responder.setHttpResponderContext(responderContext);
            if (!REQUESTING.compareAndSet(this, null, responderContext)) {
                throw new AssertionError();
            }
            while (!RESPONDERS.compareAndSet(this, oldResponders = RESPONDERS.get(this), newResponders = oldResponders.appended(responderContext))) {
            }
            this.server.willRequest(request);
            responderContext.willRequest(request);
            if (!oldResponders.isEmpty()) break block2;
            responderContext.doRespond();
        }
    }

    void didRequest(HttpRequest<?> request) {
        HttpServerResponder responderContext = REQUESTING.getAndSet(this, null);
        responderContext.didRequest(request);
        this.server.didRequest(request);
        responderContext.doRespond(request);
    }

    void doWriteResponse(HttpResponse<?> response) {
        this.willRespond(response);
        this.context.write(response.httpEncoder());
    }

    void willRespond(HttpResponse<?> response) {
        this.server.willRespond(response);
        ((HttpServerResponder)RESPONDERS.get(this).head()).willRespond(response);
    }

    void didRespond(HttpResponse<?> response) {
        block1: {
            FingerTrieSeq newResponders;
            FingerTrieSeq<HttpServerResponder<?>> oldResponders;
            while (!RESPONDERS.compareAndSet(this, oldResponders = RESPONDERS.get(this), newResponders = oldResponders.tail())) {
            }
            HttpServerResponder responderContext = (HttpServerResponder)oldResponders.head();
            responderContext.didRespond(response);
            this.server.didRespond(response);
            if (newResponders.isEmpty()) break block1;
            ((HttpServerResponder)newResponders.head()).doRespond();
        }
    }
}

