/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.codec.Decoder;
import swim.http.HttpException;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpSocket;
import swim.io.http.HttpResponder;
import swim.io.http.HttpResponderContext;
import swim.io.http.HttpServerModem;
import swim.io.http.HttpSettings;

public class HttpServerResponder<T>
implements HttpResponderContext {
    protected final HttpServerModem modem;
    protected final HttpResponder<T> responder;
    volatile HttpResponse<?> response;
    volatile int status;
    static final int RESPONDING = 1;
    static final int RESPONDED = 2;
    static final AtomicIntegerFieldUpdater<HttpServerResponder<?>> STATUS = AtomicIntegerFieldUpdater.newUpdater(HttpServerResponder.class, "status");

    public HttpServerResponder(HttpServerModem modem, HttpResponder<T> responder) {
        this.modem = modem;
        this.responder = responder;
    }

    public boolean isConnected() {
        return this.modem.isConnected();
    }

    public boolean isClient() {
        return this.modem.isClient();
    }

    public boolean isServer() {
        return this.modem.isServer();
    }

    public boolean isSecure() {
        return this.modem.isSecure();
    }

    public String securityProtocol() {
        return this.modem.securityProtocol();
    }

    public String cipherSuite() {
        return this.modem.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.modem.localAddress();
    }

    public Principal localPrincipal() {
        return this.modem.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.modem.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.modem.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.modem.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.modem.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.modem.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.modem.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.modem.flowControl(flowModifier);
    }

    @Override
    public HttpSettings httpSettings() {
        return this.modem.httpSettings();
    }

    @Override
    public void writeResponse(HttpResponse<?> response) {
        block2: {
            int oldStatus;
            this.response = response;
            while (((oldStatus = STATUS.get(this)) & 2) == 0) {
                int newStatus = oldStatus | 2;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                if ((newStatus & 1) != 0) {
                    this.modem.doWriteResponse(response);
                }
                break block2;
            }
            throw new HttpException("already responded");
        }
    }

    @Override
    public void become(IpSocket socket) {
        this.modem.become(socket);
    }

    @Override
    public void close() {
        this.modem.close();
    }

    void willRequest(HttpRequest<?> request) {
        this.responder.willRequest(request);
        Decoder<T> contentDecoder = this.responder.contentDecoder(request);
        Decoder entityDecoder = request.entityDecoder(contentDecoder);
        this.modem.doReadRequestEntity(entityDecoder);
    }

    void didRequest(HttpRequest<?> request) {
        this.responder.didRequest(request);
    }

    void doRespond(HttpRequest<?> request) {
        this.responder.doRespond(request);
    }

    void doRespond() {
        block2: {
            int oldStatus;
            while (((oldStatus = STATUS.get(this)) & 1) == 0) {
                int newStatus = oldStatus | 1;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                if ((newStatus & 2) != 0) {
                    this.modem.doWriteResponse(this.response);
                }
                break block2;
            }
            throw new AssertionError();
        }
    }

    void willRespond(HttpResponse<?> response) {
        this.responder.willRespond(response);
    }

    void didRespond(HttpResponse<?> response) {
        this.responder.didRespond(response);
    }

    void willBecome(IpSocket socket) {
        this.responder.willBecome(socket);
    }

    void didBecome(IpSocket socket) {
        this.responder.didBecome(socket);
    }

    void didTimeout() {
        this.responder.didTimeout();
    }

    void didDisconnect() {
        this.responder.didDisconnect();
    }

    void didFail(Throwable error) {
        this.responder.didFail(error);
    }
}

