/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import swim.codec.OutputBuffer;
import swim.codec.OutputException;
import swim.codec.OutputSettings;

final class ByteArrayOutput
extends OutputBuffer<ByteBuffer> {
    byte[] array;
    int index;
    int limit;
    OutputSettings settings;
    boolean isPart;

    ByteArrayOutput(byte[] array, int index, int limit, OutputSettings settings, boolean isPart) {
        this.array = array;
        this.index = index;
        this.limit = limit;
        this.settings = settings;
        this.isPart = isPart;
    }

    ByteArrayOutput(byte[] array, int offset, int length) {
        this(array, offset, offset + length, OutputSettings.standard(), false);
    }

    @Override
    public boolean isCont() {
        return this.index < this.limit;
    }

    @Override
    public boolean isFull() {
        return this.isPart && this.index >= this.limit;
    }

    @Override
    public boolean isDone() {
        return !this.isPart && this.index >= this.limit;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return this.isPart;
    }

    @Override
    public OutputBuffer<ByteBuffer> isPart(boolean isPart) {
        this.isPart = isPart;
        return this;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public OutputBuffer<ByteBuffer> index(int index) {
        if (0 <= index && index <= this.limit) {
            this.index = index;
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid index"), this.settings);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public OutputBuffer<ByteBuffer> limit(int limit) {
        if (0 <= limit && limit <= this.array.length) {
            this.limit = limit;
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid limit"), this.settings);
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public int remaining() {
        return this.limit - this.index;
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && index < this.limit;
    }

    @Override
    public int get(int index) {
        if (0 <= index && index < this.limit) {
            return this.array[index] & 0xFF;
        }
        throw new OutputException();
    }

    @Override
    public void set(int index, int token) {
        if (0 > index || index >= this.limit) {
            throw new OutputException();
        }
        this.array[index] = (byte)token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(this.array, this.index, this.limit - this.index);
        try {
            int n = channel.read(buffer);
            return n;
        }
        finally {
            this.index = buffer.position();
            this.limit = buffer.limit();
        }
    }

    @Override
    public OutputBuffer<ByteBuffer> write(int token) {
        int index = this.index;
        if (index < this.limit) {
            this.array[index] = (byte)token;
            this.index = index + 1;
            return this;
        }
        return OutputBuffer.error(new OutputException("full"), this.settings);
    }

    @Override
    public OutputBuffer<ByteBuffer> write(String string) {
        return OutputBuffer.error(new OutputException("binary output"), this.settings);
    }

    @Override
    public OutputBuffer<ByteBuffer> writeln(String string) {
        return OutputBuffer.error(new OutputException("binary output"), this.settings);
    }

    @Override
    public OutputBuffer<ByteBuffer> writeln() {
        return OutputBuffer.error(new OutputException("binary output"), this.settings);
    }

    @Override
    public OutputBuffer<ByteBuffer> move(int fromIndex, int toIndex, int length) {
        int limit;
        if (0 <= fromIndex && fromIndex <= this.limit && 0 <= (limit = toIndex + length) && limit <= this.limit) {
            System.arraycopy(this.array, fromIndex, this.array, toIndex, length);
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid move"), this.settings);
    }

    @Override
    public OutputBuffer<ByteBuffer> step(int offset) {
        int index = this.index + offset;
        if (0 <= index && index <= this.limit) {
            this.index = index;
            return this;
        }
        return OutputBuffer.error(new OutputException("invalid step"), this.settings);
    }

    @Override
    public ByteBuffer bind() {
        return ByteBuffer.wrap(this.array, 0, this.index);
    }

    @Override
    public OutputSettings settings() {
        return this.settings;
    }

    @Override
    public OutputBuffer<ByteBuffer> settings(OutputSettings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public OutputBuffer<ByteBuffer> clone() {
        return new ByteArrayOutput(this.array, this.index, this.limit, this.settings, this.isPart);
    }
}

