/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

final class InputError
extends Input {
    final Throwable error;
    final Object id;
    final Mark mark;
    final InputSettings settings;

    InputError(Throwable error, Object id, Mark mark, InputSettings settings) {
        this.error = error;
        this.id = id;
        this.mark = mark;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public Input isPart(boolean isPart) {
        return this;
    }

    @Override
    public int head() {
        throw new IllegalStateException();
    }

    @Override
    public Input step() {
        InputException error = new InputException("error step");
        return Input.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public Throwable trap() {
        return this.error;
    }

    @Override
    public Input seek(Mark mark) {
        InputException error = new InputException("error seek");
        return Input.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public Input id(Object id) {
        return Input.error(this.error, id, this.mark, this.settings);
    }

    @Override
    public Mark mark() {
        return this.mark;
    }

    @Override
    public Input mark(Mark mark) {
        return Input.error(this.error, this.id, mark, this.settings);
    }

    @Override
    public InputSettings settings() {
        return this.settings;
    }

    @Override
    public Input settings(InputSettings settings) {
        return Input.error(this.error, this.id, this.mark, settings);
    }

    @Override
    public Input clone() {
        return this;
    }
}

