/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.auth.Identity;
import swim.concurrent.PullContext;
import swim.concurrent.PullRequest;
import swim.remote.RemoteHost;
import swim.runtime.LinkKeys;
import swim.runtime.WarpBinding;
import swim.runtime.WarpContext;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.Envelope;

class RemoteWarpUplink
implements WarpContext,
PullRequest<Envelope> {
    final RemoteHost host;
    final WarpBinding link;
    final Uri remoteNodeUri;
    final Value linkKey;
    final ConcurrentLinkedQueue<Envelope> downQueue;
    PullContext<? super Envelope> pullContext;
    volatile int status;
    static final int FEEDING_DOWN = 1;
    static final int FEEDING_UP = 2;
    static final int PULLING_UP = 4;
    static final AtomicIntegerFieldUpdater<RemoteWarpUplink> STATUS = AtomicIntegerFieldUpdater.newUpdater(RemoteWarpUplink.class, "status");

    RemoteWarpUplink(RemoteHost host, WarpBinding link, Uri remoteNodeUri, Value linkKey) {
        this.host = host;
        this.link = link;
        this.remoteNodeUri = remoteNodeUri;
        this.linkKey = linkKey.commit();
        this.downQueue = new ConcurrentLinkedQueue();
    }

    RemoteWarpUplink(RemoteHost host, WarpBinding link, Uri remoteNodeUri) {
        this(host, link, remoteNodeUri, LinkKeys.generateLinkKey());
    }

    public final WarpBinding linkWrapper() {
        return this.link.linkWrapper();
    }

    public final WarpBinding linkBinding() {
        return this.link;
    }

    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final Uri nodeUri() {
        return this.link.nodeUri();
    }

    public final Uri laneUri() {
        return this.link.laneUri();
    }

    public final Value linkKey() {
        return this.linkKey;
    }

    public final float prio() {
        return this.link.prio();
    }

    public boolean isConnectedUp() {
        return this.host.isConnected();
    }

    public boolean isRemoteUp() {
        return this.host.isRemote();
    }

    public boolean isSecureUp() {
        return this.host.isSecure();
    }

    public String securityProtocolUp() {
        return this.host.securityProtocol();
    }

    public String cipherSuiteUp() {
        return this.host.cipherSuite();
    }

    public InetSocketAddress localAddressUp() {
        return this.host.localAddress();
    }

    public Identity localIdentityUp() {
        return this.host.localIdentity();
    }

    public Principal localPrincipalUp() {
        return this.host.localPrincipal();
    }

    public Collection<Certificate> localCertificatesUp() {
        return this.host.localCertificates();
    }

    public InetSocketAddress remoteAddressUp() {
        return this.host.remoteAddress();
    }

    public Identity remoteIdentityUp() {
        return this.host.remoteIdentity();
    }

    public Principal remotePrincipalUp() {
        return this.host.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificatesUp() {
        return this.host.remoteCertificates();
    }

    public void queueDown(Envelope envelope) {
        int newStatus;
        int oldStatus;
        this.downQueue.add(envelope);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.link.feedDown();
        }
    }

    public void pullDown() {
        int newStatus;
        int oldStatus;
        Envelope envelope = this.downQueue.poll();
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFE) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (envelope != null) {
            this.link.pushDown(envelope);
        }
        this.feedDownQueue();
    }

    void feedDownQueue() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = !this.downQueue.isEmpty() ? oldStatus | 1 : oldStatus) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.link.feedDown();
        }
    }

    public void feedUp() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 4) == 0 ? oldStatus & 0xFFFFFFFD | 4 : oldStatus | 2) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 4) == 0) {
            this.host.warpSocketContext.feed((PullRequest)this);
        }
    }

    public void pull(PullContext<? super Envelope> pullContext) {
        this.pullContext = pullContext;
        this.link.pullUp();
    }

    public void pushUp(Envelope envelope) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFB) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus && this.pullContext != null) {
            Envelope remoteEnvelope = envelope.nodeUri(this.remoteNodeUri);
            this.pullContext.push((Object)remoteEnvelope);
            this.pullContext = null;
        }
    }

    public void skipUp() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFB) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus && this.pullContext != null) {
            this.pullContext.skip();
            this.pullContext = null;
        }
    }

    public void closeUp() {
        this.host.closeUplink(this);
    }

    public void didOpenDown() {
    }

    public void didConnect() {
        this.link.didConnect();
    }

    public void didDisconnect() {
        this.link.didDisconnect();
        STATUS.set(this, 0);
    }

    public void didCloseDown() {
    }

    public void didCloseUp() {
        this.link.didCloseUp();
    }

    public void traceUp(Object message) {
        this.host.trace(message);
    }

    public void debugUp(Object message) {
        this.host.debug(message);
    }

    public void infoUp(Object message) {
        this.host.info(message);
    }

    public void warnUp(Object message) {
        this.host.warn(message);
    }

    public void errorUp(Object message) {
        this.host.error(message);
    }
}

