/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;

final class VarintEncoder
extends Encoder<Number, Object> {
    final long value;

    VarintEncoder(long value) {
        this.value = value;
    }

    VarintEncoder() {
        this(0L);
    }

    public Encoder<Number, Object> feed(Number input) {
        return new VarintEncoder(input.longValue());
    }

    public Encoder<Number, Object> pull(OutputBuffer<?> output) {
        return VarintEncoder.encode(output, this.value);
    }

    static int sizeOf(long value) {
        return (63 - Long.numberOfLeadingZeros(value)) / 7 + 1;
    }

    static Encoder<Number, Object> encode(OutputBuffer<?> output, long value) {
        while (output.isCont()) {
            if (value >>> 7 == 0L) {
                output = output.write((int)value & 0x7F);
                return VarintEncoder.done();
            }
            output = output.write(0x80 | (int)value & 0x7F);
            value >>>= 7;
        }
        if (output.isDone()) {
            return VarintEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return VarintEncoder.error((Throwable)output.trap());
        }
        return new VarintEncoder(value);
    }

    static Encoder<Number, Object> encodeSigned(OutputBuffer<?> output, long value) {
        value = value << 1 ^ value >> 63;
        return VarintEncoder.encode(output, value);
    }
}

