/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpEntity;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.http.header.ContentLength;
import swim.http.header.ContentType;
import swim.util.Murmur3;

public final class HttpBody<T>
extends HttpEntity<T>
implements Debug {
    final T value;
    final Encoder<?, ?> content;
    final long length;
    final MediaType mediaType;
    private static int hashSeed;
    private static HttpBody<Object> empty;

    HttpBody(T value, Encoder<?, ?> content, long length, MediaType mediaType) {
        this.value = value;
        this.content = content;
        this.length = length;
        this.mediaType = mediaType;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T get() {
        return this.value;
    }

    public Encoder<?, ?> content() {
        return this.content;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public FingerTrieSeq<TransferCoding> transferCodings() {
        return FingerTrieSeq.empty();
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        FingerTrieSeq headers = FingerTrieSeq.empty();
        if (this.mediaType != null) {
            headers = headers.appended((Object)ContentType.from(this.mediaType));
        }
        headers = headers.appended((Object)ContentLength.from(this.length));
        return headers;
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message, HttpWriter http) {
        return http.bodyEncoder(message, this.content, this.length);
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(HttpMessage<T2> message, OutputBuffer<?> output, HttpWriter http) {
        return http.encodeBody(message, this.content, this.length, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpBody) {
            HttpBody that = (HttpBody)other;
            return (this.value == null ? that.value == null : this.value.equals(that.value)) && this.content.equals(that.content) && this.length == that.length && (this.mediaType == null ? that.mediaType == null : this.mediaType.equals(that.mediaType));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpBody.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)), (int)this.content.hashCode()), (int)Murmur3.hash((long)this.length)), (int)Murmur3.hash((Object)this.mediaType)));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpBody").write(46).write("from").write(40);
        if (this.value != null) {
            output.debug(this.value).write(", ");
        }
        output.debug(this.content).write(", ").debug((Object)this.length);
        if (this.mediaType != null) {
            output = output.write(", ").debug((Object)this.mediaType);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpBody<T> empty() {
        if (empty == null) {
            empty = new HttpBody<Object>(null, Encoder.done(), 0L, null);
        }
        return empty;
    }

    public static <T> HttpBody<T> from(T value, Encoder<?, ?> content, long length, MediaType mediaType) {
        return new HttpBody<T>(value, content, length, mediaType);
    }

    public static <T> HttpBody<T> from(T value, Encoder<?, ?> content, long length) {
        return new HttpBody<T>(value, content, length, MediaType.applicationOctetStream());
    }

    public static <T> HttpBody<T> from(Encoder<?, ?> content, long length, MediaType mediaType) {
        return new HttpBody<Object>(null, content, length, mediaType);
    }

    public static <T> HttpBody<T> from(Encoder<?, ?> content, long length) {
        return new HttpBody<Object>(null, content, length, MediaType.applicationOctetStream());
    }

    public static <T> HttpBody<T> from(ByteBuffer data, MediaType mediaType) {
        return new HttpBody<Object>(null, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining(), mediaType);
    }

    public static <T> HttpBody<T> from(ByteBuffer data) {
        return HttpBody.from(data, MediaType.applicationOctetStream());
    }

    public static HttpBody<String> from(String content, MediaType mediaType) {
        Output output = Utf8.encodedOutput((Output)Binary.byteBufferOutput((int)content.length()));
        output = output.write(content);
        ByteBuffer data = (ByteBuffer)output.bind();
        return new HttpBody<String>(content, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining(), mediaType);
    }

    public static HttpBody<String> from(String content) {
        return HttpBody.from(content, MediaType.textPlain());
    }

    public static <T> HttpBody<T> fromFile(String path, MediaType mediaType) throws IOException {
        FileChannel channel = FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ);
        return new HttpBody<Object>(null, Binary.channelEncoder((ReadableByteChannel)channel), channel.size(), mediaType);
    }

    public static <T> HttpBody<T> fromFile(String path) throws IOException {
        return HttpBody.fromFile(path, MediaType.forPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> HttpBody<T> fromResource(ClassLoader classLoader, String resource, MediaType mediaType) throws IOException {
        HttpBody<Object> body = null;
        InputStream input = null;
        try {
            input = classLoader.getResourceAsStream(resource);
            if (input != null) {
                ByteBuffer data = (ByteBuffer)Binary.read((Decoder)Binary.outputParser((Output)Binary.byteBufferOutput()), (InputStream)input);
                body = new HttpBody<Object>(null, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining(), mediaType);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return body;
    }

    public static <T> HttpBody<T> fromResource(ClassLoader classLoader, String resource) throws IOException {
        return HttpBody.fromResource(classLoader, resource, MediaType.forPath(resource));
    }

    public static <T> Decoder<HttpMessage<T>> httpDecoder(HttpMessage<?> message, Decoder<T> content, long length) {
        return Http.standardParser().bodyDecoder(message, content, length);
    }

    public static <T> Decoder<HttpMessage<T>> decodeHttp(HttpMessage<?> message, Decoder<T> content, long length, InputBuffer input) {
        return Http.standardParser().decodeBody(message, content, length, input);
    }
}

