/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;

final class QValueParser
extends Parser<Float> {
    final int significand;
    final int exponent;
    final int step;

    QValueParser(int significand, int exponent, int step) {
        this.significand = significand;
        this.exponent = exponent;
        this.step = step;
    }

    public Parser<Float> feed(Input input) {
        return QValueParser.parse(input, this.significand, this.exponent, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<Float> parse(Input input, int significand, int exponent, int step) {
        int c = 0;
        if (step == 1) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont() && c == 59) {
                input = input.step();
                step = 2;
            } else if (!input.isEmpty()) {
                return QValueParser.done();
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 113) return QValueParser.error((Diagnostic)Diagnostic.expected((String)"qvalue", (Input)input));
                input = input.step();
                step = 3;
            } else if (input.isDone()) {
                return QValueParser.error((Diagnostic)Diagnostic.expected((String)"qvalue", (Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (c != 61) return QValueParser.error((Diagnostic)Diagnostic.expected((int)61, (Input)input));
                input = input.step();
                step = 4;
            } else if (input.isDone()) {
                return QValueParser.error((Diagnostic)Diagnostic.expected((int)61, (Input)input));
            }
        }
        if (step == 4) {
            if (input.isCont()) {
                c = input.head();
                if (c == 48) {
                    input = input.step();
                    significand = 0;
                    exponent = 0;
                    step = 5;
                } else {
                    if (c != 49) return QValueParser.error((Diagnostic)Diagnostic.expected((String)"0 or 1", (Input)input));
                    input = input.step();
                    significand = 1;
                    exponent = 0;
                    step = 5;
                }
            } else if (input.isDone()) {
                return QValueParser.error((Diagnostic)Diagnostic.expected((String)"0 or 1", (Input)input));
            }
        }
        if (step == 5) {
            if (input.isCont()) {
                c = input.head();
                if (c == 46) {
                    input = input.step();
                    step = 6;
                } else {
                    step = 9;
                }
            } else if (input.isDone()) {
                step = 9;
            }
        }
        while (step >= 6 && step <= 8) {
            if (input.isCont()) {
                c = input.head();
                if (Base10.isDigit((int)c)) {
                    input = input.step();
                    significand = 10 * significand + Base10.decodeDigit((int)c);
                    ++exponent;
                    ++step;
                    continue;
                }
                step = 9;
                break;
            }
            if (!input.isDone()) break;
            step = 9;
            break;
        }
        if (step == 9) {
            float weight = significand;
            while (exponent > 0) {
                weight /= 10.0f;
                --exponent;
            }
            if (!(weight <= 1.0f)) return QValueParser.error((Diagnostic)Diagnostic.message((String)("invalid qvalue: " + weight), (Input)input));
            return QValueParser.done((Object)Float.valueOf(weight));
        }
        if (!input.isError()) return new QValueParser(significand, exponent, step);
        return QValueParser.error((Throwable)input.trap());
    }

    public static Parser<Float> parse(Input input) {
        return QValueParser.parse(input, 0, 0, 1);
    }

    public static Parser<Float> parseRest(Input input) {
        return QValueParser.parse(input, 0, 0, 3);
    }
}

