/*
 * Decompiled with CFR 0.152.
 */
package swim.io.warp;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.IpSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.io.http.HttpSettings;
import swim.io.warp.WarpSettingsForm;
import swim.io.ws.WsSettings;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class WarpSettings
implements Debug {
    protected final WsSettings wsSettings;
    private static int hashSeed;
    private static WarpSettings standard;
    private static Form<WarpSettings> form;

    public WarpSettings(WsSettings wsSettings) {
        this.wsSettings = wsSettings;
    }

    public final WsSettings wsSettings() {
        return this.wsSettings;
    }

    public WarpSettings wsSettings(WsSettings wsSettings) {
        return new WarpSettings(wsSettings);
    }

    public final HttpSettings httpSettings() {
        return this.wsSettings.httpSettings();
    }

    public WarpSettings httpSettings(HttpSettings httpSettings) {
        return this.wsSettings(this.wsSettings.httpSettings(httpSettings));
    }

    public final IpSettings ipSettings() {
        return this.wsSettings.ipSettings();
    }

    public WarpSettings ipSettings(IpSettings ipSettings) {
        return this.wsSettings(this.wsSettings.ipSettings(ipSettings));
    }

    public final TlsSettings tlsSettings() {
        return this.wsSettings.tlsSettings();
    }

    public WarpSettings tlsSettings(TlsSettings tlsSettings) {
        return this.wsSettings(this.wsSettings.tlsSettings(tlsSettings));
    }

    public final TcpSettings tcpSettings() {
        return this.wsSettings.tcpSettings();
    }

    public WarpSettings tcpSettings(TcpSettings tcpSettings) {
        return this.wsSettings(this.wsSettings.tcpSettings(tcpSettings));
    }

    public Value toValue() {
        return WarpSettings.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WarpSettings) {
            WarpSettings that = (WarpSettings)other;
            return this.wsSettings.equals((Object)that.wsSettings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WarpSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.wsSettings.hashCode()));
    }

    public void debug(Output<?> output) {
        output.write("WarpSettings").write(46).write("standard").write(40).write(41).write(46).write("wsSettings").write(40).debug((Object)this.wsSettings).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static WarpSettings standard() {
        if (standard == null) {
            standard = new WarpSettings(WsSettings.standard());
        }
        return standard;
    }

    public static WarpSettings from(WsSettings wsSettings) {
        return new WarpSettings(wsSettings);
    }

    @Kind
    public static Form<WarpSettings> form() {
        if (form == null) {
            form = new WarpSettingsForm();
        }
        return form;
    }
}

