/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import java.lang.reflect.Array;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public final class ArrayForm
extends Form<Object> {
    final Class<?> type;
    final Form<Object> form;
    Object unit;

    public ArrayForm(Class<?> type, Form<?> form) {
        this.type = type;
        this.form = form;
    }

    @Override
    public Object unit() {
        if (this.unit == null) {
            this.unit = Array.newInstance(this.type, 0);
        }
        return this.unit;
    }

    @Override
    public Class<?> type() {
        return this.unit().getClass();
    }

    @Override
    public Item mold(Object array, Item item) {
        if (array != null) {
            int n = Array.getLength(array);
            for (int i = 0; i < n; ++i) {
                item = item.appended(this.form.mold(Array.get(array, i)));
            }
            return item;
        }
        return Item.extant();
    }

    @Override
    public Item mold(Object array) {
        if (array != null) {
            int n = Array.getLength(array);
            Record record = Record.create(n);
            for (int i = 0; i < n; ++i) {
                record.add(this.form.mold(Array.get(array, i)));
            }
            return record;
        }
        return Item.extant();
    }

    @Override
    public Object cast(Item item) {
        Object elem;
        Value value = item.toValue();
        int n = value.length();
        if (n > 0) {
            Object array = Array.newInstance(this.type, n);
            int k = 0;
            for (Item child : value) {
                Object elem2 = this.form.cast(child);
                if (elem2 == null) continue;
                Array.set(array, k, elem2);
                ++k;
            }
            if (k == n) {
                return array;
            }
            Object newArray = Array.newInstance(this.type, k);
            System.arraycopy(array, 0, newArray, 0, k);
            return newArray;
        }
        if (value.isDefined() && (elem = this.form.cast(value)) != null) {
            Object array = Array.newInstance(this.type, 1);
            Array.set(array, 0, elem);
            return array;
        }
        return null;
    }
}

