/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.func;

import swim.structure.Func;
import swim.structure.Record;
import swim.structure.Value;
import swim.structure.func.AbsFunc;
import swim.structure.func.CeilFunc;
import swim.structure.func.FloorFunc;
import swim.structure.func.MaxFunc;
import swim.structure.func.MinFunc;
import swim.structure.func.PowFunc;
import swim.structure.func.RandomFunc;
import swim.structure.func.RateFunc;
import swim.structure.func.RoundFunc;
import swim.structure.func.SqrtFunc;

public final class MathModule {
    private static Func max;
    private static Func min;
    private static Func abs;
    private static Func ceil;
    private static Func floor;
    private static Func round;
    private static Func sqrt;
    private static Func pow;
    private static Func rate;
    private static Func random;
    private static Record scope;

    private MathModule() {
    }

    public static Func max() {
        if (max == null) {
            max = new MaxFunc();
        }
        return max;
    }

    public static Func min() {
        if (min == null) {
            min = new MinFunc();
        }
        return min;
    }

    public static Func abs() {
        if (abs == null) {
            abs = new AbsFunc();
        }
        return abs;
    }

    public static Func ceil() {
        if (ceil == null) {
            ceil = new CeilFunc();
        }
        return ceil;
    }

    public static Func floor() {
        if (floor == null) {
            floor = new FloorFunc();
        }
        return floor;
    }

    public static Func round() {
        if (round == null) {
            round = new RoundFunc();
        }
        return round;
    }

    public static Func sqrt() {
        if (sqrt == null) {
            sqrt = new SqrtFunc();
        }
        return sqrt;
    }

    public static Func pow() {
        if (pow == null) {
            pow = new PowFunc();
        }
        return pow;
    }

    public static Func rate() {
        if (rate == null) {
            rate = new RateFunc();
        }
        return rate;
    }

    public static Func random() {
        if (random == null) {
            random = new RandomFunc();
        }
        return random;
    }

    public static Record scope() {
        if (scope == null) {
            scope = Record.create(10).slot("max", (Value)MathModule.max()).slot("min", (Value)MathModule.min()).slot("abs", (Value)MathModule.abs()).slot("ceil", (Value)MathModule.ceil()).slot("floor", (Value)MathModule.floor()).slot("round", (Value)MathModule.round()).slot("sqrt", (Value)MathModule.sqrt()).slot("pow", (Value)MathModule.pow()).slot("rate", (Value)MathModule.rate()).slot("random", (Value)MathModule.random()).commit();
        }
        return scope;
    }
}

