/*
 * Decompiled with CFR 0.152.
 */
package swim.client;

import swim.api.Downlink;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.client.Client;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.concurrent.MainStage;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.Theater;
import swim.io.IpInterface;
import swim.io.TlsSettings;
import swim.io.http.HttpEndpoint;
import swim.io.http.HttpSettings;
import swim.remote.RemoteHostClient;
import swim.runtime.AbstractSwimRef;
import swim.runtime.EdgeBinding;
import swim.runtime.EdgeContext;
import swim.runtime.HostBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.NodeBinding;
import swim.runtime.PartBinding;
import swim.runtime.PushRequest;
import swim.runtime.router.EdgeTable;
import swim.runtime.router.MeshTable;
import swim.runtime.router.PartTable;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class ClientRuntime
extends AbstractSwimRef
implements Client,
EdgeContext {
    final Stage stage;
    final HttpEndpoint endpoint;
    final EdgeBinding edge;
    StoreBinding store;

    public ClientRuntime(Stage stage, HttpSettings settings) {
        this.stage = stage;
        this.endpoint = new HttpEndpoint(stage, settings);
        this.edge = new EdgeTable();
        this.edge.setEdgeContext((EdgeContext)this);
    }

    public ClientRuntime(Stage stage) {
        this(stage, HttpSettings.standard().tlsSettings(TlsSettings.standard()));
    }

    public ClientRuntime() {
        this((Stage)new Theater());
    }

    public void start() {
        if (this.stage instanceof MainStage) {
            ((MainStage)this.stage).start();
        }
        this.endpoint.start();
        this.edge.start();
    }

    public void stop() {
        this.endpoint.stop();
        if (this.stage instanceof MainStage) {
            ((MainStage)this.stage).stop();
        }
    }

    public final EdgeBinding edgeWrapper() {
        return this.edge.edgeWrapper();
    }

    public <T> T unwrapEdge(Class<T> edgeClass) {
        if (edgeClass.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        return null;
    }

    public Uri meshUri() {
        return Uri.empty();
    }

    public Policy policy() {
        return null;
    }

    public Schedule schedule() {
        return this.stage;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final StoreBinding store() {
        return this.store;
    }

    public final HttpEndpoint endpoint() {
        return this.endpoint;
    }

    public MeshBinding createMesh(Uri meshUri) {
        return new MeshTable();
    }

    public MeshBinding injectMesh(Uri meshUri, MeshBinding mesh) {
        return mesh;
    }

    public PartBinding createPart(Uri meshUri, Value partKey) {
        return new PartTable();
    }

    public PartBinding injectPart(Uri meshUri, Value partKey, PartBinding part) {
        return part;
    }

    public HostBinding createHost(Uri meshUri, Value partKey, Uri hostUri) {
        return new RemoteHostClient(hostUri, (IpInterface)this.endpoint);
    }

    public HostBinding injectHost(Uri meshUri, Value partKey, Uri hostUri, HostBinding host) {
        return host;
    }

    public NodeBinding createNode(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return null;
    }

    public NodeBinding injectNode(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        return node;
    }

    public LaneBinding createLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, LaneDef laneDef) {
        return null;
    }

    public LaneBinding createLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return null;
    }

    public LaneBinding injectLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return lane;
    }

    public void openLanes(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
    }

    public AgentFactory<?> createAgentFactory(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, AgentDef agentDef) {
        return null;
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Class<? extends A> agentClass) {
        return null;
    }

    public void openAgents(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return null;
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.edge.bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.edge.openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
    }

    public void pushDown(PushRequest pushRequest) {
        this.edge.pushDown(pushRequest);
    }

    public void trace(Object message) {
    }

    public void debug(Object message) {
    }

    public void info(Object message) {
    }

    public void warn(Object message) {
    }

    public void error(Object message) {
    }

    public void close() {
    }

    public void willOpen() {
    }

    public void didOpen() {
    }

    public void willLoad() {
    }

    public void didLoad() {
    }

    public void willStart() {
    }

    public void didStart() {
    }

    public void willStop() {
    }

    public void didStop() {
    }

    public void willUnload() {
    }

    public void didUnload() {
    }

    public void willClose() {
    }
}

