/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Lane;
import swim.api.agent.AgentContext;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.AbstractUplinkContext;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LaneView;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.NodeBinding;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public abstract class LaneModel<View extends LaneView, U extends AbstractUplinkContext>
extends AbstractTierBinding
implements LaneBinding {
    protected LaneContext laneContext;
    protected volatile Object views;
    protected volatile FingerTrieSeq<U> uplinks = FingerTrieSeq.empty();
    protected static final AtomicReferenceFieldUpdater<LaneModel<?, ?>, Object> VIEWS = AtomicReferenceFieldUpdater.newUpdater(LaneModel.class, Object.class, "views");
    protected static final AtomicReferenceFieldUpdater<LaneModel<?, ?>, FingerTrieSeq<? extends LinkContext>> UPLINKS = AtomicReferenceFieldUpdater.newUpdater(LaneModel.class, FingerTrieSeq.class, "uplinks");

    @Override
    public final TierContext tierContext() {
        return this.laneContext;
    }

    @Override
    public final NodeBinding node() {
        return this.laneContext.node();
    }

    @Override
    public final LaneBinding laneWrapper() {
        return this;
    }

    @Override
    public final LaneContext laneContext() {
        return this.laneContext;
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        this.laneContext = laneContext;
    }

    @Override
    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.laneContext.unwrapLane(laneClass);
    }

    protected abstract U createUplink(LinkBinding var1);

    @Override
    public final Uri meshUri() {
        return this.laneContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.laneContext.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.laneContext.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.laneContext.nodeUri();
    }

    @Override
    public final Uri laneUri() {
        return this.laneContext.laneUri();
    }

    @Override
    public Policy policy() {
        return this.laneContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.laneContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.laneContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.laneContext.store();
    }

    @Override
    public Lane getLaneView(AgentContext agentContext) {
        Object views = this.views;
        if (views instanceof LaneView) {
            LaneView view = (LaneView)views;
            if (agentContext == view.agentContext()) {
                return view;
            }
        } else if (views instanceof LaneView[]) {
            for (LaneView view : (LaneView[])views) {
                if (agentContext != view.agentContext()) continue;
                return view;
            }
        }
        return null;
    }

    @Override
    public void openLaneView(Lane view) {
        LaneView[] newLaneViews;
        Object oldLaneViews;
        do {
            if ((oldLaneViews = this.views) instanceof LaneView) {
                newLaneViews = new LaneView[]{(LaneView)oldLaneViews, (LaneView)view};
                continue;
            }
            if (oldLaneViews instanceof LaneView[]) {
                LaneView[] oldLaneViewArray = (LaneView[])oldLaneViews;
                int n = oldLaneViewArray.length;
                LaneView[] newLaneViewArray = new LaneView[n + 1];
                System.arraycopy(oldLaneViewArray, 0, newLaneViewArray, 0, n);
                newLaneViewArray[n] = (LaneView)view;
                newLaneViews = newLaneViewArray;
                continue;
            }
            newLaneViews = (LaneView[])view;
        } while (!VIEWS.compareAndSet(this, oldLaneViews, newLaneViews));
        this.didOpenLaneView((LaneView)view);
        this.activate((LaneView)view);
    }

    @Override
    public void closeLaneView(Lane view) {
        LaneView[] newLaneViews;
        LaneView[] oldLaneViews;
        do {
            if ((oldLaneViews = this.views) instanceof LaneView) {
                if (oldLaneViews == view) {
                    newLaneViews = null;
                    continue;
                }
            } else if (oldLaneViews instanceof LaneView[]) {
                LaneView[] oldLaneViewArray = oldLaneViews;
                int n = oldLaneViewArray.length;
                if (n == 2) {
                    if (oldLaneViewArray[0] == view) {
                        newLaneViews = oldLaneViewArray[1];
                        continue;
                    }
                    if (oldLaneViewArray[1] == view) {
                        newLaneViews = oldLaneViewArray[0];
                        continue;
                    }
                } else {
                    int i;
                    LaneView[] newLaneViewArray = new LaneView[n - 1];
                    for (i = 0; i < n && oldLaneViewArray[i] != view; ++i) {
                        if (i >= n - 1) continue;
                        newLaneViewArray[i] = oldLaneViewArray[i];
                    }
                    if (i < n) {
                        System.arraycopy(oldLaneViewArray, i + 1, newLaneViewArray, i, n - (i + 1));
                        newLaneViews = newLaneViewArray;
                        continue;
                    }
                }
            }
            newLaneViews = oldLaneViews;
            break;
        } while (!VIEWS.compareAndSet(this, oldLaneViews, newLaneViews));
        if (oldLaneViews != newLaneViews) {
            ((LaneView)view).didClose();
            this.didCloseLaneView((LaneView)view);
        }
        if (newLaneViews == null) {
            this.close();
        }
    }

    @Override
    public FingerTrieSeq<LinkContext> uplinks() {
        return this.uplinks;
    }

    @Override
    public LinkBinding getUplink(Value linkKey) {
        FingerTrieSeq<U> uplinks = this.uplinks;
        int n = uplinks.size();
        for (int i = 0; i < n; ++i) {
            AbstractUplinkContext uplink = (AbstractUplinkContext)uplinks.get(i);
            if (!linkKey.equals((Object)uplink.linkKey())) continue;
            return uplink.linkBinding();
        }
        return null;
    }

    @Override
    public void openUplink(LinkBinding link) {
        U uplink = this.createUplink(link);
        if (uplink != null) {
            FingerTrieSeq newUplinks;
            FingerTrieSeq<U> oldUplinks;
            link.setLinkContext((LinkContext)uplink);
            while (!UPLINKS.compareAndSet(this, oldUplinks = this.uplinks, (FingerTrieSeq<? extends LinkContext>)(newUplinks = oldUplinks.appended(uplink)))) {
            }
            this.didUplink(uplink);
        } else {
            UplinkError.rejectUnsupported(link);
        }
    }

    @Override
    public void closeUplink(Value linkKey) {
        AbstractUplinkContext linkContext;
        FingerTrieSeq newUplinks;
        FingerTrieSeq oldUplinks;
        block0: do {
            newUplinks = oldUplinks = this.uplinks;
            linkContext = null;
            int n = oldUplinks.size();
            for (int i = 0; i < n; ++i) {
                AbstractUplinkContext uplink = (AbstractUplinkContext)oldUplinks.get(i);
                if (!linkKey.equals((Object)uplink.linkKey())) continue;
                linkContext = uplink;
                newUplinks = oldUplinks.removed(i);
                continue block0;
            }
        } while (!UPLINKS.compareAndSet(this, oldUplinks, newUplinks));
        if (linkContext != null) {
            linkContext.linkBinding().didCloseUp();
        }
    }

    @Override
    public abstract void pushUp(PushRequest var1);

    @Override
    public abstract void pushUpCommand(CommandMessage var1);

    protected abstract void didOpenLaneView(View var1);

    protected void didCloseLaneView(View view) {
    }

    protected void didUplink(U uplink) {
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.laneContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.laneContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.laneContext.closeDownlink(link);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.laneContext.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.laneContext.trace(message);
    }

    public void debug(Object message) {
        this.laneContext.debug(message);
    }

    public void info(Object message) {
        this.laneContext.info(message);
    }

    public void warn(Object message) {
        this.laneContext.warn(message);
    }

    public void error(Object message) {
        this.laneContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Object views = this.views;
        if (views instanceof LaneView) {
            ((LaneView)views).open();
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].open();
            }
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Object views = this.views;
        if (views instanceof LaneView) {
            ((LaneView)views).load();
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].load();
            }
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Object views = this.views;
        if (views instanceof LaneView) {
            ((LaneView)views).start();
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].start();
            }
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Object views = this.views;
        if (views instanceof LaneView) {
            ((LaneView)views).stop();
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].stop();
            }
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Object views = this.views;
        if (views instanceof LaneView) {
            ((LaneView)views).unload();
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].unload();
            }
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        FingerTrieSeq<U> uplinks = this.uplinks;
        int n = uplinks.size();
        for (int i = 0; i < n; ++i) {
            ((AbstractUplinkContext)uplinks.get(i)).close();
        }
        Object views = this.views;
        if (views instanceof LaneView) {
            ((LaneView)views).close();
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n2 = viewArray.length;
            for (int i = 0; i < n2; ++i) {
                viewArray[i].close();
            }
        }
        this.laneContext.close();
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

