/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Lane;
import swim.api.agent.AgentContext;
import swim.api.policy.Policy;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.store.StoreBinding;
import swim.uri.Uri;

public abstract class LaneView
extends AbstractTierBinding
implements Lane {
    protected volatile Object observers;
    static final AtomicReferenceFieldUpdater<LaneView, Object> OBSERVERS = AtomicReferenceFieldUpdater.newUpdater(LaneView.class, Object.class, "observers");

    public LaneView(Object observers) {
        this.observers = observers;
    }

    @Override
    public TierContext tierContext() {
        return null;
    }

    public abstract AgentContext agentContext();

    public abstract LaneBinding laneBinding();

    public LaneContext laneContext() {
        return this.laneBinding().laneContext();
    }

    public abstract LaneBinding createLaneBinding();

    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final Uri hostUri() {
        return this.laneBinding().hostUri();
    }

    public final Uri nodeUri() {
        return this.laneBinding().nodeUri();
    }

    public final Uri laneUri() {
        return this.laneBinding().laneUri();
    }

    @Override
    public abstract void close();

    public LaneView observe(Object newObserver) {
        Object[] newObservers;
        Object oldObservers;
        do {
            if ((oldObservers = this.observers) == null) {
                newObservers = newObserver;
                continue;
            }
            if (!(oldObservers instanceof Object[])) {
                Object[] newArray = new Object[]{oldObservers, newObserver};
                newObservers = newArray;
                continue;
            }
            Object[] oldArray = (Object[])oldObservers;
            int oldCount = oldArray.length;
            Object[] newArray = new Object[oldCount + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            newArray[oldCount] = newObserver;
            newObservers = newArray;
        } while (!OBSERVERS.compareAndSet(this, oldObservers, newObservers));
        return this;
    }

    public LaneView unobserve(Object oldObserver) {
        Object oldObservers;
        while ((oldObservers = this.observers) != null) {
            Object[] newObservers;
            if (!(oldObservers instanceof Object[])) {
                if (oldObservers != oldObserver) break;
                newObservers = null;
            } else {
                Object[] oldArray = (Object[])oldObservers;
                int oldCount = oldArray.length;
                if (oldCount == 2) {
                    if (oldArray[0] == oldObserver) {
                        newObservers = oldArray[1];
                    } else {
                        if (oldArray[1] != oldObserver) break;
                        newObservers = oldArray[0];
                    }
                } else {
                    int i;
                    for (i = 0; i < oldCount && oldArray[i] != oldObserver; ++i) {
                    }
                    if (i >= oldCount) break;
                    Object[] newArray = new Object[oldCount - 1];
                    System.arraycopy(oldArray, 0, newArray, 0, i);
                    System.arraycopy(oldArray, i + 1, newArray, i, oldCount - 1 - i);
                    newObservers = newArray;
                }
            }
            if (!OBSERVERS.compareAndSet(this, oldObservers, newObservers)) continue;
            break;
        }
        return this;
    }

    public void laneDidFail(Throwable error) {
    }

    @Override
    public Uri meshUri() {
        return this.laneContext().meshUri();
    }

    @Override
    public Policy policy() {
        return this.laneContext().policy();
    }

    @Override
    public Schedule schedule() {
        return this.laneContext().schedule();
    }

    @Override
    public Stage stage() {
        return this.laneContext().stage();
    }

    @Override
    public StoreBinding store() {
        return this.laneContext().store();
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.laneContext().bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.laneContext().openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.laneContext().closeDownlink(link);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.laneContext().pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.laneBinding().trace(message);
    }

    public void debug(Object message) {
        this.laneBinding().debug(message);
    }

    public void info(Object message) {
        this.laneBinding().info(message);
    }

    public void warn(Object message) {
        this.laneBinding().warn(message);
    }

    public void error(Object message) {
        this.laneBinding().error(message);
    }
}

