/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.WarpBinding;
import swim.runtime.http.HttpErrorUplinkModem;
import swim.runtime.warp.WarpErrorUplinkModem;
import swim.structure.Record;
import swim.structure.Value;

public final class UplinkError {
    private UplinkError() {
    }

    static void rejectWarp(WarpBinding link, Value body) {
        WarpErrorUplinkModem linkContext = new WarpErrorUplinkModem(link, body);
        link.setLinkContext(linkContext);
        linkContext.cueDown();
    }

    static void rejectHttp(HttpBinding link) {
        HttpErrorUplinkModem linkContext = new HttpErrorUplinkModem(link);
        link.setLinkContext(linkContext);
    }

    public static void rejectMeshNotFound(LinkBinding link) {
        if (link instanceof WarpBinding) {
            UplinkError.rejectWarp((WarpBinding)link, (Value)Record.create((int)1).attr("meshNotFound"));
        } else if (link instanceof HttpBinding) {
            UplinkError.rejectHttp((HttpBinding)link);
        } else {
            throw new AssertionError();
        }
    }

    public static void rejectPartNotFound(LinkBinding link) {
        if (link instanceof WarpBinding) {
            UplinkError.rejectWarp((WarpBinding)link, (Value)Record.create((int)1).attr("partNotFound"));
        } else if (link instanceof HttpBinding) {
            UplinkError.rejectHttp((HttpBinding)link);
        } else {
            throw new AssertionError();
        }
    }

    public static void rejectHostNotFound(LinkBinding link) {
        if (link instanceof WarpBinding) {
            UplinkError.rejectWarp((WarpBinding)link, (Value)Record.create((int)1).attr("hostNotFound"));
        } else if (link instanceof HttpBinding) {
            UplinkError.rejectHttp((HttpBinding)link);
        } else {
            throw new AssertionError();
        }
    }

    public static void rejectNodeNotFound(LinkBinding link) {
        if (link instanceof WarpBinding) {
            UplinkError.rejectWarp((WarpBinding)link, (Value)Record.create((int)1).attr("nodeNotFound"));
        } else if (link instanceof HttpBinding) {
            UplinkError.rejectHttp((HttpBinding)link);
        } else {
            throw new AssertionError();
        }
    }

    public static void rejectLaneNotFound(LinkBinding link) {
        if (link instanceof WarpBinding) {
            UplinkError.rejectWarp((WarpBinding)link, (Value)Record.create((int)1).attr("laneNotFound"));
        } else if (link instanceof HttpBinding) {
            UplinkError.rejectHttp((HttpBinding)link);
        } else {
            throw new AssertionError();
        }
    }

    public static void rejectUnsupported(LinkBinding link) {
        if (link instanceof WarpBinding) {
            UplinkError.rejectWarp((WarpBinding)link, (Value)Record.create((int)1).attr("unsupported"));
        } else if (link instanceof HttpBinding) {
            UplinkError.rejectHttp((HttpBinding)link);
        } else {
            throw new AssertionError();
        }
    }
}

