/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentContext;
import swim.api.agent.AgentFactory;
import swim.concurrent.Conts;
import swim.runtime.NodeContext;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.agent.AgentModelDidClose;
import swim.runtime.agent.AgentModelDidLoad;
import swim.runtime.agent.AgentModelDidStart;
import swim.runtime.agent.AgentModelDidStop;
import swim.runtime.agent.AgentModelDidUnload;
import swim.runtime.agent.AgentModelPushUp;
import swim.runtime.agent.AgentModelWillClose;
import swim.runtime.agent.AgentModelWillLoad;
import swim.runtime.agent.AgentModelWillStart;
import swim.runtime.agent.AgentModelWillStop;
import swim.runtime.agent.AgentModelWillUnload;
import swim.runtime.agent.AgentNode;
import swim.runtime.agent.AgentView;
import swim.structure.Value;

public class AgentModel
extends AgentNode {
    protected final Value props;
    volatile Object views;
    static final AtomicReferenceFieldUpdater<AgentModel, Object> VIEWS = AtomicReferenceFieldUpdater.newUpdater(AgentModel.class, Object.class, "views");

    public AgentModel(Value props) {
        this.props = props.commit();
    }

    @Override
    public void setNodeContext(NodeContext nodeContext) {
        super.setNodeContext(nodeContext);
    }

    public Value props() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentView createAgent(AgentFactory<?> agentFactory, Value props) {
        Agent agent;
        AgentView view = new AgentView(this, props);
        try {
            SwimContext.setAgentContext((AgentContext)view);
            agent = agentFactory.createAgent((AgentContext)view);
        }
        finally {
            SwimContext.clear();
        }
        view.setAgent(agent);
        return view;
    }

    public AgentView getAgentView(Value props) {
        Object views = this.views;
        if (views instanceof AgentView) {
            AgentView view = (AgentView)views;
            if (props.equals((Object)view.props)) {
                return view;
            }
        } else if (views instanceof AgentView[]) {
            for (AgentView view : (AgentView[])views) {
                if (!props.equals((Object)view.props)) continue;
                return view;
            }
        }
        return null;
    }

    public <S extends Agent> S getAgent(Class<S> agentClass) {
        if (this.views instanceof AgentView) {
            Agent agent = ((AgentView)this.views).agent;
            if (agentClass.isInstance(agent)) {
                return (S)agent;
            }
        } else if (this.views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])this.views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                Agent agent = viewArray[i].agent;
                if (!agentClass.isInstance(agent)) continue;
                return (S)agent;
            }
        }
        return null;
    }

    public AgentView addAgentView(AgentView view) {
        AgentView[] newViews;
        Object oldViews;
        Value props = view.props();
        do {
            AgentView oldView;
            if ((oldViews = this.views) instanceof AgentView) {
                oldView = (AgentView)oldViews;
                if (props.equals((Object)oldView.props())) {
                    return oldView;
                }
                newViews = new AgentView[]{oldView, view};
                continue;
            }
            if (oldViews instanceof AgentView[]) {
                AgentView[] oldViewArray = (AgentView[])oldViews;
                int n = oldViewArray.length;
                AgentView[] newViewArray = new AgentView[n + 1];
                for (int i = 0; i < n; ++i) {
                    oldView = oldViewArray[i];
                    if (props.equals((Object)oldView.props())) {
                        return oldView;
                    }
                    newViewArray[i] = oldViewArray[i];
                }
                newViewArray[n] = view;
                newViews = newViewArray;
                continue;
            }
            newViews = view;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        this.activate((TierBinding)view);
        this.didAddAgentView((AgentView)view);
        return view;
    }

    public <S extends Agent> S addAgent(Value props, AgentFactory<S> agentFactory) {
        AgentView[] newViews;
        Object oldViews;
        Object view = null;
        do {
            AgentView oldView;
            if ((oldViews = this.views) instanceof AgentView) {
                oldView = (AgentView)oldViews;
                if (props.equals((Object)oldView.props())) {
                    return (S)oldView.agent;
                }
                if (view == null) {
                    view = this.createAgent(agentFactory, props);
                }
                newViews = new AgentView[]{oldView, view};
                continue;
            }
            if (oldViews instanceof AgentView[]) {
                AgentView[] oldViewArray = (AgentView[])oldViews;
                int n = oldViewArray.length;
                AgentView[] newViewArray = new AgentView[n + 1];
                for (int i = 0; i < n; ++i) {
                    oldView = oldViewArray[i];
                    if (props.equals((Object)oldView.props())) {
                        return (S)oldView.agent;
                    }
                    newViewArray[i] = oldViewArray[i];
                }
                if (view == null) {
                    view = this.createAgent(agentFactory, props);
                }
                newViewArray[n] = view;
                newViews = newViewArray;
                continue;
            }
            if (view == null) {
                view = this.createAgent(agentFactory, props);
            }
            newViews = view;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        this.activate((TierBinding)view);
        this.didAddAgentView((AgentView)view);
        return (S)view.agent;
    }

    public void removeAgentView(AgentView view) {
        AgentView[] newViews;
        AgentView[] oldViews;
        do {
            if ((oldViews = this.views) instanceof AgentView) {
                if (oldViews == view) {
                    newViews = null;
                    continue;
                }
            } else if (oldViews instanceof AgentView[]) {
                AgentView[] oldViewArray = oldViews;
                int n = oldViewArray.length;
                if (n == 2) {
                    if (oldViewArray[0] == view) {
                        newViews = oldViewArray[1];
                        continue;
                    }
                    if (oldViewArray[1] == view) {
                        newViews = oldViewArray[0];
                        continue;
                    }
                } else {
                    int i;
                    AgentView[] newViewArray = new AgentView[n - 1];
                    for (i = 0; i < n && oldViewArray[i] != view; ++i) {
                        if (i >= n - 1) continue;
                        newViewArray[i] = oldViewArray[i];
                    }
                    if (i < n) {
                        System.arraycopy(oldViewArray, i + 1, newViewArray, i, n - (i + 1));
                        newViews = newViewArray;
                        continue;
                    }
                }
            }
            newViews = oldViews;
            break;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        if (oldViews != newViews) {
            this.didRemoveAgentView(view);
        }
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        this.execute(new AgentModelPushUp(this, pushRequest));
    }

    protected void didAddAgentView(AgentView view) {
    }

    protected void didRemoveAgentView(AgentView view) {
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Object views = this.views;
        if (views instanceof AgentView) {
            ((AgentView)views).willOpen();
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].willOpen();
            }
        }
    }

    @Override
    protected void didOpen() {
        super.didOpen();
        Object views = this.views;
        if (views instanceof AgentView) {
            ((AgentView)views).didOpen();
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                viewArray[i].didOpen();
            }
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        this.execute(new AgentModelWillLoad(this));
    }

    @Override
    protected void didLoad() {
        super.didLoad();
        this.execute(new AgentModelDidLoad(this));
    }

    @Override
    protected void willStart() {
        super.willStart();
        this.execute(new AgentModelWillStart(this));
    }

    @Override
    protected void didStart() {
        super.didStart();
        this.execute(new AgentModelDidStart(this));
    }

    @Override
    protected void willStop() {
        super.willStop();
        this.execute(new AgentModelWillStop(this));
    }

    @Override
    protected void didStop() {
        super.didStop();
        this.execute(new AgentModelDidStop(this));
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        this.execute(new AgentModelWillUnload(this));
    }

    @Override
    protected void didUnload() {
        super.didUnload();
        this.execute(new AgentModelDidUnload(this));
    }

    @Override
    public void willClose() {
        super.willClose();
        this.execute(new AgentModelWillClose(this));
    }

    @Override
    public void didClose() {
        super.didClose();
        this.execute(new AgentModelDidClose(this));
    }

    @Override
    public void didFail(Throwable error) {
        super.didFail(error);
        Object views = this.views;
        if (views instanceof AgentView) {
            try {
                ((AgentView)views).didFail(error);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cause.printStackTrace();
                }
                throw cause;
            }
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    viewArray[i].didFail(error);
                    continue;
                }
                catch (Throwable cause) {
                    if (Conts.isNonFatal((Throwable)cause)) {
                        cause.printStackTrace();
                        continue;
                    }
                    throw cause;
                }
            }
        }
    }
}

