/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.api.Lane;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.data.MapData;
import swim.api.downlink.MapDownlink;
import swim.api.lane.JoinMapLane;
import swim.api.lane.function.DidDownlinkMap;
import swim.api.lane.function.WillDownlinkMap;
import swim.api.warp.function.DidCommand;
import swim.api.warp.function.DidEnter;
import swim.api.warp.function.DidLeave;
import swim.api.warp.function.DidUplink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillEnter;
import swim.api.warp.function.WillLeave;
import swim.api.warp.function.WillUplink;
import swim.concurrent.Conts;
import swim.observable.function.DidClear;
import swim.observable.function.DidRemoveKey;
import swim.observable.function.DidUpdateKey;
import swim.observable.function.WillClear;
import swim.observable.function.WillRemoveKey;
import swim.observable.function.WillUpdateKey;
import swim.runtime.CellContext;
import swim.runtime.LaneContext;
import swim.runtime.lane.JoinMapLaneDownlink;
import swim.runtime.lane.JoinMapLaneModel;
import swim.runtime.warp.WarpLaneView;
import swim.structure.Form;
import swim.structure.Value;
import swim.uri.Uri;

public class JoinMapLaneView<L, K, V>
extends WarpLaneView
implements JoinMapLane<L, K, V> {
    protected final AgentContext agentContext;
    protected Form<L> linkForm;
    protected Form<K> keyForm;
    protected Form<V> valueForm;
    protected int flags;
    protected JoinMapLaneModel laneBinding;
    protected MapData<K, V> dataView;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    JoinMapLaneView(AgentContext agentContext, Form<L> linkForm, Form<K> keyForm, Form<V> valueForm, int flags, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.linkForm = linkForm;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
        this.flags = flags;
    }

    public JoinMapLaneView(AgentContext agentContext, Form<L> linkForm, Form<K> keyForm, Form<V> valueForm) {
        this(agentContext, linkForm, keyForm, valueForm, 1, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public JoinMapLaneModel laneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(JoinMapLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public JoinMapLaneModel createLaneBinding() {
        return new JoinMapLaneModel(this.flags);
    }

    public final Form<L> linkForm() {
        return this.linkForm;
    }

    public <L2> JoinMapLaneView<L2, K, V> linkForm(Form<L2> linkForm) {
        return new JoinMapLaneView<L2, K, V>(this.agentContext, linkForm, this.keyForm, this.valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <L2> JoinMapLaneView<L2, K, V> linkClass(Class<L2> linkClass) {
        return this.linkForm(Form.forClass(linkClass));
    }

    public void setLinkForm(Form<L> linkForm) {
        this.linkForm = linkForm;
    }

    public final Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> JoinMapLaneView<L, K2, V> keyForm(Form<K2> keyForm) {
        return new JoinMapLaneView<L, K2, V>(this.agentContext, this.linkForm, keyForm, this.valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <K2> JoinMapLaneView<L, K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public void setKeyForm(Form<K> keyForm) {
        this.keyForm = keyForm;
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> JoinMapLaneView<L, K, V2> valueForm(Form<V2> valueForm) {
        return new JoinMapLaneView<L, K, V2>(this.agentContext, this.linkForm, this.keyForm, valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <V2> JoinMapLaneView<L, K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public JoinMapLaneView<L, K, V> isResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        JoinMapLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isResident(isResident);
        }
        return this;
    }

    void didSetResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public JoinMapLaneView<L, K, V> isTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        JoinMapLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isTransient(isTransient);
        }
        return this;
    }

    void didSetTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    protected void willLoad() {
        this.dataView = this.laneBinding.data.keyForm(this.keyForm).valueForm(this.valueForm);
        super.willLoad();
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public JoinMapLaneView<L, K, V> observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public JoinMapLaneView<L, K, V> unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public JoinMapLaneView<L, K, V> willDownlink(WillDownlinkMap<L> willDownlink) {
        return this.observe(willDownlink);
    }

    public JoinMapLaneView<L, K, V> didDownlink(DidDownlinkMap<L> didDownlink) {
        return this.observe(didDownlink);
    }

    public JoinMapLaneView<L, K, V> willUpdate(WillUpdateKey<K, V> willUpdate) {
        return this.observe(willUpdate);
    }

    public JoinMapLaneView<L, K, V> didUpdate(DidUpdateKey<K, V> didUpdate) {
        return this.observe(didUpdate);
    }

    public JoinMapLaneView<L, K, V> willRemove(WillRemoveKey<K> willRemove) {
        return this.observe(willRemove);
    }

    public JoinMapLaneView<L, K, V> didRemove(DidRemoveKey<K, V> didRemove) {
        return this.observe(didRemove);
    }

    public JoinMapLaneView<L, K, V> willClear(WillClear willClear) {
        return this.observe(willClear);
    }

    public JoinMapLaneView<L, K, V> didClear(DidClear didClear) {
        return this.observe(didClear);
    }

    @Override
    public JoinMapLaneView<L, K, V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public JoinMapLaneView<L, K, V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public JoinMapLaneView<L, K, V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public JoinMapLaneView<L, K, V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public JoinMapLaneView<L, K, V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public JoinMapLaneView<L, K, V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public JoinMapLaneView<L, K, V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public JoinMapLaneView<L, K, V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillUpdate(Link link, K key, V newValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillUpdateKey) {
                if (((WillUpdateKey)observers).isPreemptive() == preemptive) {
                    try {
                        newValue = ((WillUpdateKey)observers).willUpdate(key, newValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillUpdateKey)) continue;
                    if (((WillUpdateKey)observer).isPreemptive() == preemptive) {
                        try {
                            newValue = ((WillUpdateKey)observer).willUpdate(key, newValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUpdate(Link link, K key, V newValue, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidUpdateKey) {
                if (((DidUpdateKey)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidUpdateKey)observers).didUpdate(key, newValue, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidUpdateKey)) continue;
                    if (((DidUpdateKey)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidUpdateKey)observer).didUpdate(key, newValue, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillRemove(Link link, K key, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillRemoveKey) {
                if (((WillRemoveKey)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillRemoveKey)observers).willRemove(key);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillRemoveKey)) continue;
                    if (((WillRemoveKey)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillRemoveKey)observer).willRemove(key);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidRemove(Link link, K key, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidRemoveKey) {
                if (((DidRemoveKey)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidRemoveKey)observers).didRemove(key, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidRemoveKey)) continue;
                    if (((DidRemoveKey)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidRemoveKey)observer).didRemove(key, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillClear) {
                if (((WillClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillClear)observers).willClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillClear)) continue;
                    if (((WillClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillClear)observer).willClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidClear) {
                if (((DidClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidClear)observers).didClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidClear)) continue;
                    if (((DidClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidClear)observer).didClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, MapDownlink<?, ?>> dispatchWillDownlink(L key, MapDownlink<?, ?> downlink, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        try {
            SwimContext.setLane((Lane)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillDownlinkMap) {
                if (((WillDownlinkMap)observers).isPreemptive() == preemptive) {
                    try {
                        downlink = ((WillDownlinkMap)observers).willDownlink(key, downlink);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillDownlinkMap)) continue;
                    if (((WillDownlinkMap)observer).isPreemptive() == preemptive) {
                        try {
                            downlink = ((WillDownlinkMap)observer).willDownlink(key, downlink);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(complete, downlink);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidDownlink(L key, MapDownlink<?, ?> downlink, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        try {
            SwimContext.setLane((Lane)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidDownlinkMap) {
                if (((DidDownlinkMap)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidDownlinkMap)observers).didDownlink(key, downlink);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidDownlinkMap)) continue;
                    if (((DidDownlinkMap)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidDownlinkMap)observer).didDownlink(key, downlink);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public MapDownlink<K, V> laneWillDownlink(L key, MapDownlink<K, V> downlink) {
        return downlink;
    }

    public void laneDidDownlink(K key, MapDownlink<K, V> downlink) {
    }

    public V laneWillUpdate(K key, V newValue) {
        return newValue;
    }

    public void laneDidUpdate(K key, V newValue, V oldValue) {
    }

    public void laneWillRemove(K key) {
    }

    public void laneDidRemove(K key, V oldValue) {
    }

    public void laneWillClear() {
    }

    public void laneDidClear() {
    }

    public MapDownlink<K, V> downlink(L key) {
        LaneContext laneContext = this.laneBinding.laneContext();
        return new JoinMapLaneDownlink<K, V>((CellContext)laneContext, laneContext.stage(), this.laneBinding, this.linkForm.mold(key).toValue(), this.laneBinding.meshUri(), Uri.empty(), Uri.empty(), Uri.empty(), 0.0f, 0.0f, Value.absent(), this.keyForm, this.valueForm);
    }

    public boolean isEmpty() {
        return this.dataView.isEmpty();
    }

    public int size() {
        return this.dataView.size();
    }

    public boolean containsKey(Object key) {
        return this.dataView.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.dataView.containsValue(value);
    }

    public V get(Object key) {
        return (V)this.dataView.get(key);
    }

    public MapDownlink<?, ?> getDownlink(Object key) {
        return this.laneBinding.getDownlink(this.linkForm.mold(key));
    }

    public V put(K key, V value) {
        return this.laneBinding.put(this, key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.laneBinding.put(this, entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(key)) {
            return this.laneBinding.remove(this, key);
        }
        return (V)this.valueForm.unit();
    }

    public void clear() {
        this.laneBinding.clear(this);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.dataView.entrySet();
    }

    public Set<K> keySet() {
        return this.dataView.keySet();
    }

    public Collection<V> values() {
        return this.dataView.values();
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return this.dataView.iterator();
    }

    public Iterator<K> keyIterator() {
        return this.dataView.keyIterator();
    }

    public Iterator<V> valueIterator() {
        return this.dataView.valueIterator();
    }

    public Iterator<Map.Entry<L, MapDownlink<?, ?>>> downlinkIterator() {
        return this.laneBinding.downlinks.iterator();
    }
}

