/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.Link;
import swim.concurrent.Stage;
import swim.runtime.LaneRelay;
import swim.runtime.lane.MapLaneModel;
import swim.runtime.lane.MapLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class MapLaneRelayUpdate
extends LaneRelay<MapLaneModel, MapLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;
    Form<Object> keyForm;
    Form<Object> valueForm;
    final Value key;
    Object keyObject;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    MapLaneRelayUpdate(MapLaneModel model, CommandMessage message, Value key, Value newValue) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.key = key;
        this.newValue = newValue;
    }

    MapLaneRelayUpdate(MapLaneModel model, Link link, Value key, Value newValue) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.key = key;
        this.newValue = newValue;
    }

    MapLaneRelayUpdate(MapLaneModel model, Stage stage, Value key, Value newValue) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.key = key;
        this.newValue = newValue;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            this.oldValue = (Value)((MapLaneModel)this.model).data.put((Object)this.key, (Object)this.newValue);
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    protected boolean runPhase(MapLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillUpdate(this.keyObject, this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillUpdate(this.link, this.keyObject, this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidUpdate(this.keyObject, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.link, this.keyObject, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((MapLaneModel)this.model).cueDownKey(this.key);
    }
}

