/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import swim.api.data.SpatialData;
import swim.collections.FingerTrieSeq;
import swim.math.Z2Form;
import swim.runtime.LaneView;
import swim.runtime.WarpBinding;
import swim.runtime.lane.SpatialLaneRelayClear;
import swim.runtime.lane.SpatialLaneRelayMove;
import swim.runtime.lane.SpatialLaneRelayRemove;
import swim.runtime.lane.SpatialLaneRelayUpdate;
import swim.runtime.lane.SpatialLaneUplink;
import swim.runtime.lane.SpatialLaneView;
import swim.runtime.warp.WarpLaneModel;
import swim.spatial.SpatialMap;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class SpatialLaneModel<S>
extends WarpLaneModel<SpatialLaneView<?, S, ?>, SpatialLaneUplink<S>> {
    protected int flags;
    protected SpatialData<Value, S, Value> data;
    protected final Z2Form<S> shapeForm;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    SpatialLaneModel(Z2Form<S> shapeForm, int flags) {
        this.shapeForm = shapeForm;
        this.flags = flags;
    }

    public SpatialLaneModel(Z2Form<S> shapeForm) {
        this(shapeForm, 0);
    }

    @Override
    public String laneType() {
        return "spatial";
    }

    @Override
    protected SpatialLaneUplink<S> createWarpUplink(WarpBinding link) {
        return new SpatialLaneUplink(this, link);
    }

    @Override
    public void onCommand(CommandMessage message) {
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            Value key = header.get("key");
            Value shape = header.get("shape");
            Object shapeObject = this.shapeForm.cast((Item)shape);
            Value value = payload.body();
            new SpatialLaneRelayUpdate<Object>(this, message, key, shapeObject, value).run();
        } else if ("move".equals(tag)) {
            Value header = payload.header("move");
            Value key = header.get("key");
            Value oldShape = header.get("from");
            Value newShape = header.get("to");
            Object oldShapeObject = this.shapeForm.cast((Item)oldShape);
            Object newShapeObject = this.shapeForm.cast((Item)newShape);
            Value value = payload.body();
            new SpatialLaneRelayMove<Object>(this, message, key, oldShapeObject, newShapeObject, value).run();
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            Value key = header.get("key");
            Value shape = header.get("shape");
            Object shapeObject = this.shapeForm.cast((Item)shape);
            new SpatialLaneRelayRemove<Object>(this, message, key, shapeObject).run();
        } else if ("clear".equals(tag)) {
            new SpatialLaneRelayClear(this, message).run();
        }
    }

    protected void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((SpatialLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    @Override
    protected void didOpenLaneView(SpatialLaneView<?, S, ?> view) {
        view.setLaneBinding(this);
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public SpatialLaneModel<S> isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof SpatialLaneView) {
            ((SpatialLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((SpatialLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public SpatialLaneModel<S> isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof SpatialLaneView) {
            ((SpatialLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((SpatialLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public Value get(Value key) {
        if (key != null) {
            return (Value)this.data.get((Object)key);
        }
        return Value.absent();
    }

    public <K, V> V put(SpatialLaneView<K, S, V> view, K keyObject, S shapeObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        SpatialLaneRelayUpdate<S> relay = new SpatialLaneRelayUpdate<S>(this, this.stage(), key, shapeObject, newValue);
        relay.keyForm = keyForm;
        relay.shapeForm = this.shapeForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public <K, V> V move(SpatialLaneView<K, S, V> view, K keyObject, S oldShapeObject, S newShapeObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        SpatialLaneRelayMove<S> relay = new SpatialLaneRelayMove<S>(this, this.stage(), key, oldShapeObject, newShapeObject, newValue);
        relay.keyForm = keyForm;
        relay.shapeForm = this.shapeForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public <K, V> V remove(SpatialLaneView<K, S, V> view, K keyObject, S shapeObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        SpatialLaneRelayRemove<S> relay = new SpatialLaneRelayRemove<S>(this, this.stage(), key, shapeObject);
        relay.keyForm = keyForm;
        relay.shapeForm = this.shapeForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public void clear(SpatialLaneView<?, S, ?> view) {
        SpatialLaneRelayClear relay = new SpatialLaneRelayClear(this, this.stage());
        relay.run();
    }

    public Iterator<SpatialMap.Entry<Value, S, Value>> iterator(S shape) {
        return this.data.iterator(shape);
    }

    public Iterator<SpatialMap.Entry<Value, S, Value>> iterator() {
        return this.data.iterator();
    }

    protected void openStore() {
        this.data = this.laneContext.store().spatialData(this.laneUri().toString(), this.shapeForm).isTransient(this.isTransient()).isResident(this.isResident());
    }

    @Override
    protected void willLoad() {
        this.openStore();
        super.willLoad();
    }
}

