/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.DownlinkModel;
import swim.runtime.DownlinkView;
import swim.runtime.EdgeBinding;
import swim.runtime.EdgeContext;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.router.EdgeTableMesh;
import swim.store.StoreBinding;
import swim.uri.Uri;

public class EdgeTable
extends AbstractTierBinding
implements EdgeBinding {
    protected EdgeContext edgeContext;
    volatile HashTrieMap<Uri, MeshBinding> meshes = HashTrieMap.empty();
    volatile MeshBinding network;
    static final AtomicReferenceFieldUpdater<EdgeTable, HashTrieMap<Uri, MeshBinding>> MESHES = AtomicReferenceFieldUpdater.newUpdater(EdgeTable.class, HashTrieMap.class, "meshes");

    @Override
    public final TierContext tierContext() {
        return this.edgeContext;
    }

    @Override
    public final EdgeBinding edgeWrapper() {
        return this;
    }

    @Override
    public final EdgeContext edgeContext() {
        return this.edgeContext;
    }

    @Override
    public void setEdgeContext(EdgeContext edgeContext) {
        this.edgeContext = edgeContext;
    }

    @Override
    public <T> T unwrapEdge(Class<T> edgeClass) {
        if (edgeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.edgeContext.unwrapEdge(edgeClass);
    }

    protected MeshContext createMeshContext(MeshBinding mesh, Uri meshUri) {
        return new EdgeTableMesh(this, mesh, meshUri);
    }

    @Override
    public final Uri meshUri() {
        return Uri.empty();
    }

    @Override
    public Policy policy() {
        return this.edgeContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.edgeContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.edgeContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.edgeContext.store();
    }

    @Override
    public MeshBinding network() {
        return this.network;
    }

    @Override
    public void setNetwork(MeshBinding network) {
        this.network = network;
    }

    @Override
    public HashTrieMap<Uri, MeshBinding> meshes() {
        return this.meshes;
    }

    @Override
    public MeshBinding getMesh(Uri meshUri) {
        return (MeshBinding)this.meshes.get((Object)meshUri);
    }

    @Override
    public MeshBinding openMesh(Uri meshUri) {
        HashTrieMap newMeshes;
        HashTrieMap oldMeshes;
        TierBinding meshBinding = null;
        do {
            MeshBinding mesh;
            if ((mesh = (MeshBinding)(oldMeshes = this.meshes).get((Object)meshUri)) != null) {
                if (meshBinding != null) {
                    meshBinding.close();
                }
                meshBinding = mesh;
                newMeshes = oldMeshes;
                break;
            }
            if (meshBinding == null) {
                meshBinding = this.edgeContext.createMesh(meshUri);
                if (meshBinding != null) {
                    meshBinding = this.edgeContext.injectMesh(meshUri, (MeshBinding)meshBinding);
                    MeshContext meshContext = this.createMeshContext((MeshBinding)meshBinding, meshUri);
                    meshBinding.setMeshContext(meshContext);
                    meshBinding = meshBinding.meshWrapper();
                    newMeshes = oldMeshes.updated((Object)meshUri, (Object)meshBinding);
                    continue;
                }
                newMeshes = oldMeshes;
                break;
            }
            newMeshes = oldMeshes.updated((Object)meshUri, (Object)meshBinding);
        } while (oldMeshes != newMeshes && !MESHES.compareAndSet(this, (HashTrieMap<Uri, MeshBinding>)oldMeshes, (HashTrieMap<Uri, MeshBinding>)newMeshes));
        if (oldMeshes != newMeshes) {
            this.activate(meshBinding);
        }
        return meshBinding;
    }

    @Override
    public MeshBinding openMesh(Uri meshUri, MeshBinding mesh) {
        HashTrieMap newMeshes;
        HashTrieMap oldMeshes;
        MeshBinding meshBinding = null;
        do {
            if ((oldMeshes = this.meshes).containsKey((Object)meshUri)) {
                meshBinding = null;
                newMeshes = oldMeshes;
                break;
            }
            if (meshBinding != null) continue;
            meshBinding = this.edgeContext.injectMesh(meshUri, mesh);
            MeshContext meshContext = this.createMeshContext(meshBinding, meshUri);
            meshBinding.setMeshContext(meshContext);
            meshBinding = meshBinding.meshWrapper();
        } while (oldMeshes != (newMeshes = oldMeshes.updated((Object)meshUri, meshBinding)) && !MESHES.compareAndSet(this, (HashTrieMap<Uri, MeshBinding>)oldMeshes, (HashTrieMap<Uri, MeshBinding>)newMeshes));
        if (meshBinding != null) {
            this.activate(meshBinding);
        }
        return meshBinding;
    }

    public void closeMesh(Uri meshUri) {
        HashTrieMap newMeshes;
        HashTrieMap oldMeshes;
        MeshBinding meshBinding = null;
        do {
            MeshBinding mesh;
            if ((mesh = (MeshBinding)(oldMeshes = this.meshes).get((Object)meshUri)) == null) {
                meshBinding = null;
                newMeshes = oldMeshes;
                break;
            }
            meshBinding = mesh;
            newMeshes = oldMeshes.removed((Object)meshUri);
        } while (oldMeshes != newMeshes && !MESHES.compareAndSet(this, (HashTrieMap<Uri, MeshBinding>)oldMeshes, (HashTrieMap<Uri, MeshBinding>)newMeshes));
        if (meshBinding != null) {
            if (this.network == meshBinding) {
                this.network = null;
            }
            meshBinding.didClose();
        }
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        DownlinkModel<?> link = ((DownlinkView)downlink).createDownlinkModel();
        this.openUplink(link);
        return link;
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.openUplink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        MeshBinding meshBinding = this.openMesh(link.meshUri());
        if (meshBinding != null) {
            meshBinding.openUplink(link);
        } else {
            UplinkError.rejectMeshNotFound(link);
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.pushUp(pushRequest);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        MeshBinding meshBinding = this.openMesh(pushRequest.meshUri());
        if (meshBinding != null) {
            meshBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.edgeContext.trace(message);
    }

    public void debug(Object message) {
        this.edgeContext.debug(message);
    }

    public void info(Object message) {
        this.edgeContext.info(message);
    }

    public void warn(Object message) {
        this.edgeContext.warn(message);
    }

    public void error(Object message) {
        this.edgeContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator meshesIterator = this.meshes.valueIterator();
        while (meshesIterator.hasNext()) {
            ((MeshBinding)meshesIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

