/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PartPredicate;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.WarpBinding;
import swim.runtime.router.PartTableHost;
import swim.runtime.router.PartTableHttpUplink;
import swim.runtime.router.PartTableWarpUplink;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class PartTable
extends AbstractTierBinding
implements PartBinding {
    final PartPredicate predicate;
    protected PartContext partContext;
    volatile HashTrieMap<Uri, HostBinding> hosts = HashTrieMap.empty();
    volatile HashTrieMap<Value, LinkBinding> uplinks = HashTrieMap.empty();
    volatile HostBinding master;
    static final AtomicReferenceFieldUpdater<PartTable, HashTrieMap<Uri, HostBinding>> HOSTS = AtomicReferenceFieldUpdater.newUpdater(PartTable.class, HashTrieMap.class, "hosts");
    static final AtomicReferenceFieldUpdater<PartTable, HashTrieMap<Value, LinkBinding>> UPLINKS = AtomicReferenceFieldUpdater.newUpdater(PartTable.class, HashTrieMap.class, "uplinks");

    public PartTable(PartPredicate predicate) {
        this.predicate = predicate;
    }

    public PartTable() {
        this(PartPredicate.any());
    }

    @Override
    public final TierContext tierContext() {
        return this.partContext;
    }

    @Override
    public final MeshBinding mesh() {
        return this.partContext.mesh();
    }

    @Override
    public final PartBinding partWrapper() {
        return this;
    }

    @Override
    public final PartContext partContext() {
        return this.partContext;
    }

    @Override
    public void setPartContext(PartContext partContext) {
        this.partContext = partContext;
    }

    @Override
    public <T> T unwrapPart(Class<T> partClass) {
        if (partClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.partContext.unwrapPart(partClass);
    }

    protected HostContext createHostContext(HostBinding host, Uri hostUri) {
        return new PartTableHost(this, host, hostUri);
    }

    @Override
    public final Uri meshUri() {
        return this.partContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.partContext.partKey();
    }

    @Override
    public Policy policy() {
        return this.partContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.partContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.partContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.partContext.store();
    }

    @Override
    public PartPredicate predicate() {
        return this.predicate;
    }

    @Override
    public HostBinding master() {
        return this.master;
    }

    @Override
    public void setMaster(HostBinding master) {
        this.master = master;
    }

    @Override
    public HashTrieMap<Uri, HostBinding> hosts() {
        return this.hosts;
    }

    @Override
    public HostBinding getHost(Uri hostUri) {
        return (HostBinding)this.hosts.get((Object)hostUri);
    }

    @Override
    public HostBinding openHost(Uri hostUri) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        TierBinding hostBinding = null;
        do {
            HostBinding host;
            if ((host = (HostBinding)(oldHosts = this.hosts).get((Object)hostUri)) != null) {
                if (hostBinding != null) {
                    hostBinding.close();
                }
                hostBinding = host;
                newHosts = oldHosts;
                break;
            }
            if (hostBinding == null) {
                hostBinding = this.partContext.createHost(hostUri);
                if (hostBinding != null) {
                    hostBinding = this.partContext.injectHost(hostUri, (HostBinding)hostBinding);
                    HostContext hostContext = this.createHostContext((HostBinding)hostBinding, hostUri);
                    hostBinding.setHostContext(hostContext);
                    hostBinding = hostBinding.hostWrapper();
                    newHosts = oldHosts.updated((Object)hostUri, (Object)hostBinding);
                    continue;
                }
                newHosts = oldHosts;
                break;
            }
            newHosts = oldHosts.updated((Object)hostUri, (Object)hostBinding);
        } while (oldHosts != newHosts && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (oldHosts != newHosts) {
            this.activate(hostBinding);
        }
        return hostBinding;
    }

    @Override
    public HostBinding openHost(Uri hostUri, HostBinding host) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        HostBinding hostBinding = null;
        do {
            if ((oldHosts = this.hosts).containsKey((Object)hostUri) && host.hostContext() != null) {
                hostBinding = null;
                newHosts = oldHosts;
                break;
            }
            if (hostBinding != null) continue;
            hostBinding = this.partContext.injectHost(hostUri, host);
            HostContext hostContext = this.createHostContext(hostBinding, hostUri);
            hostBinding.setHostContext(hostContext);
            hostBinding = hostBinding.hostWrapper();
        } while (oldHosts != (newHosts = oldHosts.updated((Object)hostUri, hostBinding)) && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (hostBinding != null) {
            this.activate(hostBinding);
        }
        return hostBinding;
    }

    public void closeHost(Uri hostUri) {
        HashTrieMap newHosts;
        HashTrieMap oldHosts;
        HostBinding hostBinding = null;
        do {
            HostBinding host;
            if ((host = (HostBinding)(oldHosts = this.hosts).get((Object)hostUri)) == null) {
                hostBinding = null;
                newHosts = oldHosts;
                break;
            }
            hostBinding = host;
            newHosts = oldHosts.removed((Object)hostUri);
        } while (oldHosts != newHosts && !HOSTS.compareAndSet(this, (HashTrieMap<Uri, HostBinding>)oldHosts, (HashTrieMap<Uri, HostBinding>)newHosts));
        if (hostBinding != null) {
            if (this.master == hostBinding) {
                this.master = null;
            }
            hostBinding.didClose();
        }
    }

    public void hostDidConnect(Uri hostUri) {
        this.partContext.hostDidConnect(hostUri);
    }

    public void hostDidDisconnect(Uri hostUri) {
        this.partContext.hostDidDisconnect(hostUri);
    }

    @Override
    public void reopenUplinks() {
        for (LinkBinding uplink : this.uplinks.values()) {
            uplink.reopen();
        }
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.partContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.partContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        Uri hostUri = link.hostUri();
        HostBinding hostBinding = null;
        if (!hostUri.isDefined() || hostUri.equals((Object)link.meshUri())) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(hostUri);
        }
        if (hostBinding != null) {
            if (link instanceof WarpBinding) {
                hostBinding.openUplink(new PartTableWarpUplink(this, (WarpBinding)link));
            } else if (link instanceof HttpBinding) {
                hostBinding.openUplink(new PartTableHttpUplink(this, (HttpBinding)link));
            } else {
                UplinkError.rejectUnsupported(link);
            }
        } else {
            UplinkError.rejectHostNotFound(link);
        }
    }

    void didOpenUplink(LinkBinding uplink) {
        HashTrieMap newUplinks;
        HashTrieMap<Value, LinkBinding> oldUplinks;
        while ((oldUplinks = this.uplinks) != (newUplinks = oldUplinks.updated((Object)uplink.linkKey(), (Object)uplink)) && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Value, LinkBinding>)newUplinks)) {
        }
    }

    void didCloseUplink(LinkBinding uplink) {
        HashTrieMap newUplinks;
        HashTrieMap<Value, LinkBinding> oldUplinks;
        while ((oldUplinks = this.uplinks) != (newUplinks = oldUplinks.removed((Object)uplink.linkKey())) && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Value, LinkBinding>)newUplinks)) {
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.partContext.pushDown(pushRequest);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        Uri hostUri = pushRequest.hostUri();
        HostBinding hostBinding = null;
        if (!hostUri.isDefined() || hostUri.equals((Object)pushRequest.meshUri())) {
            hostBinding = this.master;
        }
        if (hostBinding == null) {
            hostBinding = this.openHost(hostUri);
        }
        if (hostBinding != null) {
            hostBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.partContext.trace(message);
    }

    public void debug(Object message) {
        this.partContext.debug(message);
    }

    public void info(Object message) {
        this.partContext.info(message);
    }

    public void warn(Object message) {
        this.partContext.warn(message);
    }

    public void error(Object message) {
        this.partContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator hostsIterator = this.hosts.valueIterator();
        while (hostsIterator.hasNext()) {
            ((HostBinding)hostsIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

