/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import swim.api.Downlink;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.PartBinding;
import swim.runtime.PushRequest;
import swim.runtime.router.PartTable;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class PartTableHost
implements HostContext {
    protected final PartTable part;
    protected final HostBinding host;
    protected final Uri hostUri;

    public PartTableHost(PartTable part, HostBinding host, Uri hostUri) {
        this.part = part;
        this.host = host;
        this.hostUri = hostUri;
    }

    @Override
    public final PartBinding part() {
        return this.part;
    }

    @Override
    public final HostBinding hostWrapper() {
        return this.host.hostWrapper();
    }

    @Override
    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public final Uri meshUri() {
        return this.part.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.part.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.hostUri;
    }

    @Override
    public Policy policy() {
        return this.part.policy();
    }

    @Override
    public Schedule schedule() {
        return this.part.schedule();
    }

    @Override
    public Stage stage() {
        return this.part.stage();
    }

    @Override
    public StoreBinding store() {
        return this.part.store();
    }

    @Override
    public NodeBinding createNode(Uri nodeUri) {
        return this.part.partContext().createNode(this.hostUri, nodeUri);
    }

    @Override
    public NodeBinding injectNode(Uri nodeUri, NodeBinding node) {
        return this.part.partContext().injectNode(this.hostUri, nodeUri, node);
    }

    @Override
    public LaneBinding createLane(Uri nodeUri, LaneDef laneDef) {
        return this.part.partContext().createLane(this.hostUri, nodeUri, laneDef);
    }

    @Override
    public LaneBinding createLane(Uri nodeUri, Uri laneUri) {
        return this.part.partContext().createLane(this.hostUri, nodeUri, laneUri);
    }

    @Override
    public LaneBinding injectLane(Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return this.part.partContext().injectLane(this.hostUri, nodeUri, laneUri, lane);
    }

    @Override
    public void openLanes(Uri nodeUri, NodeBinding node) {
        this.part.partContext().openLanes(this.hostUri, nodeUri, node);
    }

    @Override
    public AgentFactory<?> createAgentFactory(Uri nodeUri, AgentDef agentDef) {
        return this.part.partContext().createAgentFactory(this.hostUri, nodeUri, agentDef);
    }

    @Override
    public <A extends Agent> AgentFactory<A> createAgentFactory(Uri nodeUri, Class<? extends A> agentClass) {
        return this.part.partContext().createAgentFactory(this.hostUri, nodeUri, agentClass);
    }

    @Override
    public void openAgents(Uri nodeUri, NodeBinding node) {
        this.part.partContext().openAgents(this.hostUri, nodeUri, node);
    }

    @Override
    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.part.partContext().authenticate(credentials);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.part.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.part.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.part.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.part.trace(message);
    }

    public void debug(Object message) {
        this.part.debug(message);
    }

    public void info(Object message) {
        this.part.info(message);
    }

    public void warn(Object message) {
        this.part.warn(message);
    }

    public void error(Object message) {
        this.part.error(message);
    }

    @Override
    public void close() {
        this.part.closeHost(this.hostUri);
    }

    @Override
    public void willOpen() {
    }

    @Override
    public void didOpen() {
    }

    @Override
    public void willLoad() {
    }

    @Override
    public void didLoad() {
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void didConnect() {
        this.part.hostDidConnect(this.hostUri);
    }

    @Override
    public void didDisconnect() {
        this.part.hostDidDisconnect(this.hostUri);
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willUnload() {
    }

    @Override
    public void didUnload() {
    }

    @Override
    public void willClose() {
    }
}

