/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieSet;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Value;
import swim.uri.Uri;

public abstract class PartialDownlinkModem<View extends WarpDownlinkView>
extends WarpDownlinkModel<View> {
    final ConcurrentLinkedQueue<Value> upQueue = new ConcurrentLinkedQueue();
    volatile HashTrieSet<Value> keyQueue = HashTrieSet.empty();
    volatile Value lastKey;
    static final AtomicReferenceFieldUpdater<PartialDownlinkModem<?>, HashTrieSet<Value>> KEY_QUEUE = AtomicReferenceFieldUpdater.newUpdater(PartialDownlinkModem.class, HashTrieSet.class, "keyQueue");

    public PartialDownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    protected boolean upQueueIsEmpty() {
        return this.upQueue.isEmpty();
    }

    @Override
    protected void queueUp(Value body) {
        this.upQueue.add(body);
    }

    public void cueUpKey(Value key) {
        HashTrieSet newKeyQueue;
        HashTrieSet oldKeyQueue;
        do {
            if ((oldKeyQueue = this.keyQueue).contains((Object)key)) {
                newKeyQueue = oldKeyQueue;
                break;
            }
            newKeyQueue = oldKeyQueue.added((Object)key);
        } while (!KEY_QUEUE.compareAndSet(this, (HashTrieSet<Value>)oldKeyQueue, (HashTrieSet<Value>)newKeyQueue));
        if (oldKeyQueue != newKeyQueue) {
            this.cueUp();
        }
    }

    protected void cueUpKeys(Collection<? extends Value> keys) {
        if (!keys.isEmpty()) {
            HashTrieSet newKeyQueue;
            HashTrieSet<Value> oldKeyQueue;
            while (!KEY_QUEUE.compareAndSet(this, oldKeyQueue = this.keyQueue, (HashTrieSet<Value>)(newKeyQueue = oldKeyQueue.added(keys)))) {
            }
            this.cueUp();
        }
    }

    protected abstract Value nextUpKey(Value var1);

    @Override
    protected Value nextUpQueue() {
        return this.upQueue.poll();
    }

    @Override
    protected Value nextUpCue() {
        Value key;
        HashTrieSet newKeyQueue;
        HashTrieSet<Value> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.removed((Object)(key = (Value)oldKeyQueue.next((Object)this.lastKey)))) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieSet<Value>)newKeyQueue)) {
        }
        if (key != null) {
            this.lastKey = key;
            return this.nextUpKey(key);
        }
        return null;
    }

    @Override
    protected void feedUp() {
        if (!this.keyQueue.isEmpty()) {
            this.cueUp();
        }
        super.feedUp();
    }
}

