/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import swim.api.Lane;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.auth.Identity;
import swim.api.warp.WarpLane;
import swim.api.warp.WarpUplink;
import swim.api.warp.function.DidCommand;
import swim.api.warp.function.DidEnter;
import swim.api.warp.function.DidLeave;
import swim.api.warp.function.DidUplink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillEnter;
import swim.api.warp.function.WillLeave;
import swim.api.warp.function.WillUplink;
import swim.concurrent.Conts;
import swim.runtime.LaneView;
import swim.structure.Value;
import swim.warp.CommandMessage;

public abstract class WarpLaneView
extends LaneView
implements WarpLane {
    public WarpLaneView(Object observers) {
        super(observers);
    }

    @Override
    public WarpLaneView observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public WarpLaneView unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public abstract WarpLaneView willCommand(WillCommand var1);

    public abstract WarpLaneView didCommand(DidCommand var1);

    public abstract WarpLaneView willUplink(WillUplink var1);

    public abstract WarpLaneView didUplink(DidUplink var1);

    public abstract WarpLaneView willEnter(WillEnter var1);

    public abstract WarpLaneView didEnter(DidEnter var1);

    public abstract WarpLaneView willLeave(WillLeave var1);

    public abstract WarpLaneView didLeave(DidLeave var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillCommand(Value body, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        try {
            SwimContext.setLane((Lane)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillCommand) {
                if (((WillCommand)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillCommand)observers).willCommand(body);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillCommand)) continue;
                    if (((WillCommand)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillCommand)observer).willCommand(body);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidCommand(Value body, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        try {
            SwimContext.setLane((Lane)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidCommand) {
                if (((DidCommand)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidCommand)observers).didCommand(body);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidCommand)) continue;
                    if (((DidCommand)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidCommand)observer).didCommand(body);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillUplink(WarpUplink uplink, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillUplink) {
                if (((WillUplink)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillUplink)observers).willUplink(uplink);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillUplink)) continue;
                    if (((WillUplink)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillUplink)observer).willUplink(uplink);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUplink(WarpUplink uplink, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidUplink) {
                if (((DidUplink)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidUplink)observers).didUplink(uplink);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidUplink)) continue;
                    if (((DidUplink)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidUplink)observer).didUplink(uplink);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillEnter(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillEnter) {
                if (((WillEnter)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillEnter)observers).willEnter(identity);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillEnter)) continue;
                    if (((WillEnter)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillEnter)observer).willEnter(identity);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidEnter(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidEnter) {
                if (((DidEnter)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidEnter)observers).didEnter(identity);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidEnter)) continue;
                    if (((DidEnter)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidEnter)observer).didEnter(identity);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillLeave(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillLeave) {
                if (((WillLeave)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillLeave)observers).willLeave(identity);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillLeave)) continue;
                    if (((WillLeave)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillLeave)observer).willLeave(identity);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidLeave(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidLeave) {
                if (((DidLeave)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidLeave)observers).didLeave(identity);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidLeave)) continue;
                    if (((DidLeave)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidLeave)observer).didLeave(identity);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public void laneWillCommand(CommandMessage message) {
    }

    public void laneDidCommand(CommandMessage message) {
    }

    public void laneWillUplink(WarpUplink uplink) {
    }

    public void laneDidUplink(WarpUplink uplink) {
    }

    public void laneWillEnter(Identity identity) {
    }

    public void laneDidEnter(Identity identity) {
    }

    public void laneWillLeave(Identity identity) {
    }

    public void laneDidLeave(Identity identity) {
    }
}

