/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import swim.io.IpSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class IpSettingsForm
extends Form<IpSettings> {
    IpSettingsForm() {
    }

    public IpSettings unit() {
        return IpSettings.standard();
    }

    public Class<?> type() {
        return IpSettings.class;
    }

    public Item mold(IpSettings settings) {
        if (settings != null) {
            Record record = Record.create((int)2);
            record.add(TcpSettings.form().mold((Object)settings.tcpSettings));
            record.add(TlsSettings.form().mold((Object)settings.tlsSettings));
            return record;
        }
        return Item.extant();
    }

    public IpSettings cast(Item item) {
        Value value = item.toValue();
        TcpSettings tcpSettings = null;
        TlsSettings tlsSettings = null;
        for (Item member : value) {
            TlsSettings newTlsSettings;
            TcpSettings newTcpSettings = (TcpSettings)TcpSettings.form().cast(member);
            if (newTcpSettings != null) {
                tcpSettings = newTcpSettings;
            }
            if ((newTlsSettings = (TlsSettings)TlsSettings.form().cast(member)) == null) continue;
            tlsSettings = newTlsSettings;
        }
        if (tcpSettings == null) {
            tcpSettings = TcpSettings.standard();
        }
        if (tlsSettings == null) {
            tlsSettings = TlsSettings.standard();
        }
        return new IpSettings(tcpSettings, tlsSettings);
    }
}

