/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import swim.io.FlowControl;
import swim.io.IpInterface;
import swim.io.IpService;
import swim.io.IpServiceRef;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketRef;
import swim.io.Station;
import swim.io.StationException;
import swim.io.TcpService;
import swim.io.TcpSocket;
import swim.io.TlsService;
import swim.io.TlsSettings;
import swim.io.TlsSocket;

public interface IpStation
extends IpInterface {
    public Station station();

    @Override
    default public IpServiceRef bindTcp(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        try {
            Station station = this.station();
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().setReuseAddress(true);
            serverChannel.socket().bind(localAddress, this.station().transportSettings.backlog);
            TcpService context = new TcpService(this.station(), localAddress, serverChannel, service, ipSettings);
            service.setIpServiceContext(context);
            this.station().transport(context, FlowControl.ACCEPT);
            context.didBind();
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    @Override
    default public IpServiceRef bindTls(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        try {
            Station station = this.station();
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().setReuseAddress(true);
            serverChannel.socket().bind(localAddress, station.transportSettings.backlog);
            TlsService context = new TlsService(station, localAddress, serverChannel, service, ipSettings);
            service.setIpServiceContext(context);
            station.transport(context, FlowControl.ACCEPT);
            context.didBind();
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    @Override
    default public IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        try {
            Station station = this.station();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            ipSettings.configure(channel.socket());
            boolean connected = channel.connect(remoteAddress);
            InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
            TcpSocket context = new TcpSocket(localAddress, remoteAddress, channel, ipSettings, true);
            context.become(socket);
            if (connected) {
                station.transport(context, FlowControl.WAIT);
                context.didConnect();
            } else {
                context.willConnect();
                station.transport(context, FlowControl.CONNECT);
            }
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    @Override
    default public IpSocketRef connectTls(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        try {
            Collection<String> protocols;
            Station station = this.station();
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            ipSettings.configure(channel.socket());
            TlsSettings tlsSettings = ipSettings.tlsSettings();
            SSLEngine sslEngine = tlsSettings.sslContext().createSSLEngine();
            sslEngine.setUseClientMode(true);
            switch (tlsSettings.clientAuth()) {
                case NEED: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case WANT: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
                case NONE: {
                    sslEngine.setWantClientAuth(false);
                    break;
                }
            }
            Collection<String> cipherSuites = tlsSettings.cipherSuites();
            if (cipherSuites != null) {
                sslEngine.setEnabledCipherSuites(cipherSuites.toArray(new String[cipherSuites.size()]));
            }
            if ((protocols = tlsSettings.protocols()) != null) {
                sslEngine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            }
            boolean connected = channel.connect(remoteAddress);
            InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
            TlsSocket context = new TlsSocket(localAddress, remoteAddress, channel, sslEngine, ipSettings, true);
            context.become(socket);
            if (connected) {
                station.transport(context, FlowControl.WAIT);
                context.didConnect();
            } else {
                context.willConnect();
                station.transport(context, FlowControl.CONNECT);
            }
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }
}

