/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import swim.collections.FingerTrieSeq;
import swim.collections.FingerTrieSeqSegmenter;

final class FingerTrieSeqIterator<T>
implements ListIterator<T> {
    final FingerTrieSeqSegmenter segmenter;
    Object[] page;
    int pageIndex;
    int index;

    FingerTrieSeqIterator(FingerTrieSeq<T> trie) {
        this.segmenter = new FingerTrieSeqSegmenter(trie);
        this.page = this.segmenter.hasNext() ? this.segmenter.next() : FingerTrieSeq.EMPTY_LEAF;
    }

    FingerTrieSeqIterator(FingerTrieSeq<T> trie, int index) {
        int n = index - trie.prefix.length;
        if (n < 0) {
            this.segmenter = new FingerTrieSeqSegmenter(trie, 1);
            this.page = trie.prefix;
            this.pageIndex = index;
        } else if (index < trie.length) {
            int j = n - (trie.branch.length << 5);
            if (j < 0) {
                this.segmenter = new FingerTrieSeqSegmenter(trie, 1 + (n >> 5));
                this.page = this.segmenter.next();
                this.pageIndex = n & 0x1F;
            } else {
                this.segmenter = new FingerTrieSeqSegmenter(trie, 1 + trie.branch.length);
                this.page = this.segmenter.next();
                this.pageIndex = j;
            }
        } else {
            this.segmenter = new FingerTrieSeqSegmenter(trie, trie.length);
            this.page = FingerTrieSeq.EMPTY_LEAF;
            this.pageIndex = 0;
        }
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        return this.pageIndex < this.page.length;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T next() {
        if (this.pageIndex < this.page.length) {
            Object head = this.page[this.pageIndex];
            ++this.pageIndex;
            ++this.index;
            if (this.pageIndex >= this.page.length) {
                this.page = this.segmenter.hasNext() ? this.segmenter.next() : FingerTrieSeq.EMPTY_LEAF;
                this.pageIndex = 0;
            }
            return (T)head;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public T previous() {
        if (this.pageIndex > 0) {
            --this.index;
            --this.pageIndex;
            return (T)this.page[this.pageIndex];
        }
        this.segmenter.previous();
        if (this.segmenter.hasPrevious()) {
            --this.index;
            this.page = this.segmenter.previous();
            this.pageIndex = this.page.length - 1;
            this.segmenter.next();
            return (T)this.page[this.pageIndex];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void add(T elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

