/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import swim.io.IpInterface;
import swim.io.IpSettings;
import swim.io.http.HttpSettings;
import swim.io.warp.WarpSettings;
import swim.io.ws.WsSettings;
import swim.kernel.KernelProxy;
import swim.remote.RemoteHostClient;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.structure.Value;
import swim.uri.Uri;

public class RemoteKernel
extends KernelProxy {
    final double kernelPriority;
    WarpSettings warpSettings;
    private static final double KERNEL_PRIORITY = 0.25;

    public RemoteKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
    }

    public RemoteKernel() {
        this(0.25);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public HttpSettings httpSettings() {
        return HttpSettings.from((IpSettings)this.ipSettings());
    }

    public WsSettings wsSettings() {
        return WsSettings.from((HttpSettings)this.httpSettings());
    }

    public final WarpSettings warpSettings() {
        if (this.warpSettings == null) {
            this.warpSettings = WarpSettings.from((WsSettings)this.wsSettings());
        }
        return this.warpSettings;
    }

    public HostBinding createHost(String edgeName, Uri meshUri, Value partKey, Uri hostUri) {
        if (hostUri.host().isDefined() && !"swim".equals(partKey.stringValue(null))) {
            IpInterface endpoint = (IpInterface)this.kernelWrapper().unwrapKernel(IpInterface.class);
            return new RemoteHostClient(hostUri, endpoint, this.warpSettings());
        }
        return super.createHost(edgeName, meshUri, partKey, hostUri);
    }

    public HostBinding createHost(String edgeName, Uri meshUri, Value partKey, HostDef hostDef) {
        Uri hostUri = hostDef.hostUri();
        if (hostUri != null && hostUri.host().isDefined() && !"swim".equals(partKey.stringValue(null))) {
            IpInterface endpoint = (IpInterface)this.kernelWrapper().unwrapKernel(IpInterface.class);
            return new RemoteHostClient(hostUri, endpoint, this.warpSettings());
        }
        return super.createHost(edgeName, meshUri, partKey, hostUri);
    }

    public static RemoteKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || RemoteKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(0.25);
            return new RemoteKernel(kernelPriority);
        }
        return null;
    }
}

