/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.DimensionException;
import swim.math.TensorDimsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public final class TensorDims
implements Debug {
    public final int size;
    public final int stride;
    final TensorDims next;
    private static int hashSeed;
    private static TensorDims undefined;
    private static TensorDims d1;
    private static TensorDims d2;
    private static TensorDims d3;
    private static TensorDims d4;
    private static TensorDims d2x2;
    private static TensorDims d3x3;
    private static TensorDims d4x4;
    private static Form<TensorDims> form;

    TensorDims(int size, int stride, TensorDims next) {
        this.size = size;
        this.stride = stride;
        this.next = next;
    }

    public boolean isDefined() {
        return this.size != 0 || this.stride != 0 || this.next != null;
    }

    public int rank() {
        TensorDims dim = this;
        int n = 0;
        do {
            dim = dim.next;
            ++n;
        } while (dim != null);
        return n;
    }

    public int size() {
        return this.size;
    }

    public int stride() {
        return this.stride;
    }

    public TensorDims next() {
        return this.next;
    }

    public boolean isPacked() {
        return this.stride == (this.next != null ? this.next.size * this.next.stride : 1);
    }

    public boolean isFullyPacked() {
        TensorDims dim = this;
        do {
            if (dim.isPacked()) continue;
            return false;
        } while ((dim = dim.next) != null);
        return true;
    }

    public TensorDims by(int size, int stride) {
        if (!this.isDefined()) {
            return TensorDims.of(size, stride);
        }
        if (stride == this.size * this.stride) {
            return this.by(size);
        }
        return new TensorDims(size, stride, this);
    }

    public TensorDims by(int size) {
        if (!this.isDefined()) {
            return TensorDims.of(size);
        }
        if (size == 2 && this == TensorDims.d2()) {
            return TensorDims.d2x2();
        }
        if (size == 3 && this == TensorDims.d3()) {
            return TensorDims.d3x3();
        }
        if (size == 4 && this == TensorDims.d4()) {
            return TensorDims.d4x4();
        }
        return new TensorDims(size, this.size * this.stride, this);
    }

    public TensorDims flattened() {
        TensorDims dim = this;
        int size = 1;
        do {
            if (dim.stride == (dim.next != null ? dim.next.size * dim.next.stride : 1)) {
                size *= dim.size;
                continue;
            }
            throw new DimensionException("flattened sparse dimensions");
        } while ((dim = dim.next) != null);
        return TensorDims.of(size);
    }

    public int[] toSizeArray(int[] sizes) {
        TensorDims dim = this;
        int i = 0;
        do {
            sizes[i] = dim.size;
            dim = dim.next;
            ++i;
        } while (dim != null);
        return sizes;
    }

    public int[] toSizeArray() {
        int[] sizes = new int[this.rank()];
        return this.toSizeArray(sizes);
    }

    public int[] toStrideArray(int[] strides) {
        TensorDims dim = this;
        int i = 0;
        do {
            strides[i] = dim.stride;
            dim = dim.next;
            ++i;
        } while (dim != null);
        return strides;
    }

    public int[] toStrideArray() {
        int[] strides = new int[this.rank()];
        return this.toStrideArray(strides);
    }

    public Value toValue() {
        return TensorDims.form().mold((Object)this).toValue();
    }

    public boolean conforms(TensorDims that) {
        return TensorDims.conforms(this, that);
    }

    private static boolean conforms(TensorDims these, TensorDims those) {
        do {
            if (these.size != those.size) {
                return false;
            }
            these = these.next;
            those = those.next;
        } while (these != null && those != null);
        return these == null && those == null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TensorDims) {
            return TensorDims.equals(this, (TensorDims)other);
        }
        return false;
    }

    static boolean equals(TensorDims these, TensorDims those) {
        do {
            if (these.size != those.size || these.stride != those.stride) {
                return false;
            }
            these = these.next;
            those = those.next;
        } while (these != null && those != null);
        return these == null && those == null;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TensorDims.class);
        }
        return Murmur3.mash((int)TensorDims.hash(hashSeed, this));
    }

    static int hash(int code, TensorDims dim) {
        do {
            code = Murmur3.mix((int)Murmur3.mix((int)code, (int)dim.size), (int)dim.stride);
        } while ((dim = dim.next) != null);
        return code;
    }

    public void debug(Output<?> output) {
        if (this.next != null) {
            output = output.debug((Object)this.next).write(46).write("by").write(40).debug((Object)this.size);
            if (!this.isPacked()) {
                output = output.write(", ").debug((Object)this.stride);
            }
            output = output.write(41);
        } else {
            output = output.write("TensorDims").write(46).write("of").write(40).debug((Object)this.size);
            if (!this.isPacked()) {
                output = output.write(", ").debug((Object)this.stride);
            }
            output = output.write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static TensorDims undefined() {
        if (undefined == null) {
            undefined = new TensorDims(0, 0, null);
        }
        return undefined;
    }

    public static TensorDims d1() {
        if (d1 == null) {
            d1 = new TensorDims(1, 1, null);
        }
        return d1;
    }

    public static TensorDims d2() {
        if (d2 == null) {
            d2 = new TensorDims(2, 1, null);
        }
        return d2;
    }

    public static TensorDims d3() {
        if (d3 == null) {
            d3 = new TensorDims(3, 1, null);
        }
        return d3;
    }

    public static TensorDims d4() {
        if (d4 == null) {
            d4 = new TensorDims(4, 1, null);
        }
        return d4;
    }

    public static TensorDims d2x2() {
        if (d2x2 == null) {
            d2x2 = new TensorDims(2, 2, TensorDims.d2());
        }
        return d2x2;
    }

    public static TensorDims d3x3() {
        if (d3x3 == null) {
            d3x3 = new TensorDims(3, 3, TensorDims.d3());
        }
        return d3x3;
    }

    public static TensorDims d4x4() {
        if (d4x4 == null) {
            d4x4 = new TensorDims(4, 4, TensorDims.d4());
        }
        return d4x4;
    }

    public static TensorDims of(int size, int stride) {
        if (size == 0 && stride == 0) {
            return TensorDims.undefined();
        }
        if (stride == 1) {
            return TensorDims.of(size);
        }
        return new TensorDims(size, stride, null);
    }

    public static TensorDims of(int size) {
        if (size == 0) {
            return TensorDims.undefined();
        }
        if (size == 1) {
            return TensorDims.d1();
        }
        if (size == 2) {
            return TensorDims.d2();
        }
        if (size == 3) {
            return TensorDims.d3();
        }
        if (size == 4) {
            return TensorDims.d4();
        }
        return new TensorDims(size, 1, null);
    }

    @Kind
    public static Form<TensorDims> form() {
        if (form == null) {
            form = new TensorDimsForm();
        }
        return form;
    }
}

