/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

final class InputDone
extends Input {
    final Object id;
    final Mark mark;
    final InputSettings settings;

    InputDone(Object id, Mark mark, InputSettings settings) {
        this.id = id;
        this.mark = mark;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public Input isPart(boolean isPart) {
        if (isPart) {
            return Input.empty(this.id, this.mark, this.settings);
        }
        return this;
    }

    @Override
    public int head() {
        throw new IllegalStateException();
    }

    @Override
    public Input step() {
        InputException error = new InputException("done step");
        return Input.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public Input seek(Mark mark) {
        InputException error = new InputException("empty seek");
        return Input.error(error, this.id, this.mark, this.settings);
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public Input id(Object id) {
        return Input.done(id, this.mark, this.settings);
    }

    @Override
    public Mark mark() {
        return this.mark;
    }

    @Override
    public Input mark(Mark mark) {
        return Input.done(this.id, mark, this.settings);
    }

    @Override
    public InputSettings settings() {
        return this.settings;
    }

    @Override
    public Input settings(InputSettings settings) {
        return Input.done(this.id, this.mark, settings);
    }

    @Override
    public Input clone() {
        return this;
    }
}

