/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Decoder;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.ParserDone;
import swim.codec.ParserError;
import swim.codec.ParserException;

public abstract class Parser<O>
extends Decoder<O> {
    private static Parser<Object> done;

    @Override
    public boolean isCont() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    public abstract Parser<O> feed(Input var1);

    @Override
    public Parser<O> feed(InputBuffer input) {
        return this.feed((Input)input);
    }

    @Override
    public Parser<O> fork(Object condition) {
        return this;
    }

    @Override
    public O bind() {
        throw new IllegalStateException();
    }

    @Override
    public Throwable trap() {
        throw new IllegalStateException();
    }

    @Override
    public <O2> Parser<O2> asError() {
        throw new IllegalStateException();
    }

    public static <O> Parser<O> done() {
        if (done == null) {
            done = new ParserDone<Object>(null);
        }
        return done;
    }

    public static <O> Parser<O> done(O output) {
        if (output == null) {
            return Parser.done();
        }
        return new ParserDone<O>(output);
    }

    public static <O> Parser<O> error(Throwable error) {
        return new ParserError(error);
    }

    public static <O> Parser<O> error(Diagnostic diagnostic) {
        return Parser.error(new ParserException(diagnostic));
    }
}

