/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;
import swim.util.Builder;

final class MessageDecoder<I, V>
extends Decoder<V> {
    final ProtobufDecoder<I, V> protobuf;
    final Decoder<V> payloadDecoder;
    final Decoder<I> fieldDecoder;
    final Builder<I, V> builder;

    MessageDecoder(ProtobufDecoder<I, V> protobuf, Decoder<V> payloadDecoder, Decoder<I> fieldDecoder, Builder<I, V> builder) {
        this.protobuf = protobuf;
        this.payloadDecoder = payloadDecoder;
        this.fieldDecoder = fieldDecoder;
        this.builder = builder;
    }

    public Decoder<V> feed(InputBuffer input) {
        return MessageDecoder.decode(input, this.protobuf, this.payloadDecoder, this.fieldDecoder, this.builder);
    }

    static <I, V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<I, V> protobuf, Decoder<V> payloadDecoder, Decoder<I> fieldDecoder, Builder<I, V> builder) {
        while (input.isCont()) {
            if ((fieldDecoder = fieldDecoder == null ? protobuf.decodeField(payloadDecoder, input) : fieldDecoder.feed(input)).isDone()) {
                if (builder == null) {
                    builder = protobuf.messageBuilder();
                }
                builder.add(fieldDecoder.bind());
                fieldDecoder = null;
                continue;
            }
            if (!fieldDecoder.isError()) continue;
            return fieldDecoder.asError();
        }
        if (input.isDone()) {
            if (fieldDecoder == null) {
                if (builder == null) {
                    builder = protobuf.messageBuilder();
                }
                return MessageDecoder.done((Object)builder.bind());
            }
            return MessageDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MessageDecoder.error((Throwable)input.trap());
        }
        return new MessageDecoder<I, V>(protobuf, payloadDecoder, fieldDecoder, builder);
    }

    static <I, V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<I, V> protobuf, Decoder<V> payloadDecoder) {
        return MessageDecoder.decode(input, protobuf, payloadDecoder, null, null);
    }
}

