/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import swim.concurrent.Clock;
import swim.concurrent.ClockDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class ClockForm
extends Form<ClockDef> {
    final ClockDef unit;

    ClockForm(ClockDef unit) {
        this.unit = unit;
    }

    public String tag() {
        return "clock";
    }

    public ClockDef unit() {
        return this.unit;
    }

    public Form<ClockDef> unit(ClockDef unit) {
        return new ClockForm(unit);
    }

    public Class<ClockDef> type() {
        return ClockDef.class;
    }

    public Item mold(ClockDef clockDef) {
        if (clockDef != null) {
            Record record = Record.create((int)3).attr(this.tag());
            record.slot("tickMillis", clockDef.tickMillis);
            record.slot("tickCount", clockDef.tickCount);
            return record;
        }
        return Item.extant();
    }

    public ClockDef cast(Item item) {
        Value value = item.toValue();
        Value header = value.getAttr(this.tag());
        if (header.isDefined()) {
            int tickMillis = value.get("tickMillis").intValue(Clock.TICK_MILLIS);
            int tickCount = value.get("tickCount").intValue(Clock.TICK_COUNT);
            return new ClockDef(tickMillis, tickCount);
        }
        return null;
    }
}

