/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.api.auth.Identity;
import swim.collections.FingerTrieSeq;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public abstract class AbstractDownlinkBinding
implements LinkBinding,
Log {
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;
    protected final Uri laneUri;

    public AbstractDownlinkBinding(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri) {
        this.meshUri = meshUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
    }

    @Override
    public abstract LinkBinding linkWrapper();

    @Override
    public abstract LinkContext linkContext();

    @Override
    public abstract CellContext cellContext();

    @Override
    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.linkContext().unwrapLink(linkClass);
    }

    @Override
    public final Uri meshUri() {
        return this.meshUri;
    }

    @Override
    public final Uri hostUri() {
        return this.hostUri;
    }

    @Override
    public final Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public final Uri laneUri() {
        return this.laneUri;
    }

    @Override
    public final Value linkKey() {
        return this.linkContext().linkKey();
    }

    @Override
    public boolean isConnectedDown() {
        return true;
    }

    @Override
    public boolean isRemoteDown() {
        return false;
    }

    @Override
    public boolean isSecureDown() {
        return true;
    }

    @Override
    public String securityProtocolDown() {
        return null;
    }

    @Override
    public String cipherSuiteDown() {
        return null;
    }

    @Override
    public InetSocketAddress localAddressDown() {
        return null;
    }

    @Override
    public final Identity localIdentityDown() {
        return null;
    }

    @Override
    public Principal localPrincipalDown() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificatesDown() {
        return FingerTrieSeq.empty();
    }

    @Override
    public InetSocketAddress remoteAddressDown() {
        return null;
    }

    @Override
    public final Identity remoteIdentityDown() {
        return null;
    }

    @Override
    public Principal remotePrincipalDown() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificatesDown() {
        return FingerTrieSeq.empty();
    }

    public boolean isConnected() {
        return this.linkContext().isConnectedUp();
    }

    public boolean isRemote() {
        return this.linkContext().isRemoteUp();
    }

    public boolean isSecure() {
        return this.linkContext().isSecureUp();
    }

    public String securityProtocol() {
        return this.linkContext().securityProtocolUp();
    }

    public String cipherSuite() {
        return this.linkContext().cipherSuiteUp();
    }

    public InetSocketAddress localAddress() {
        return this.linkContext().localAddressUp();
    }

    public Identity localIdentity() {
        return this.linkContext().localIdentityUp();
    }

    public Principal localPrincipal() {
        return this.linkContext().localPrincipalUp();
    }

    public Collection<Certificate> localCertificates() {
        return this.linkContext().localCertificatesUp();
    }

    public InetSocketAddress remoteAddress() {
        return this.linkContext().remoteAddressUp();
    }

    public Identity remoteIdentity() {
        return this.linkContext().remoteIdentityUp();
    }

    public Principal remotePrincipal() {
        return this.linkContext().remotePrincipalUp();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.linkContext().remoteCertificatesUp();
    }

    @Override
    public abstract void reopen();

    @Override
    public abstract void openDown();

    @Override
    public abstract void closeDown();

    @Override
    public abstract void didConnect();

    @Override
    public abstract void didDisconnect();

    @Override
    public abstract void didCloseUp();

    @Override
    public abstract void didFail(Throwable var1);

    @Override
    public void traceDown(Object message) {
    }

    @Override
    public void debugDown(Object message) {
    }

    @Override
    public void infoDown(Object message) {
    }

    @Override
    public void warnDown(Object message) {
    }

    @Override
    public void errorDown(Object message) {
    }

    public void trace(Object message) {
        this.linkContext().traceUp(message);
    }

    public void debug(Object message) {
        this.linkContext().debugUp(message);
    }

    public void info(Object message) {
        this.linkContext().infoUp(message);
    }

    public void warn(Object message) {
        this.linkContext().warnUp(message);
    }

    public void error(Object message) {
        this.linkContext().errorUp(message);
    }
}

