/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.runtime.PartPredicate;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriPattern;
import swim.util.Murmur3;

final class NodePartPredicate
extends PartPredicate {
    final UriPattern nodePattern;

    NodePartPredicate(UriPattern nodePattern) {
        this.nodePattern = nodePattern;
    }

    @Override
    public boolean test(Uri nodeUri, int nodeHash) {
        return this.nodePattern.matches(nodeUri);
    }

    @Override
    public Value toValue() {
        return Record.create((int)1).attr("node", this.nodePattern.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof NodePartPredicate) {
            NodePartPredicate that = (NodePartPredicate)other;
            return this.nodePattern.equals((Object)that.nodePattern);
        }
        return false;
    }

    public int hashCode() {
        return Murmur3.mash((int)Murmur3.mix((int)1813239977, (int)this.nodePattern.hashCode()));
    }

    public String toString() {
        return "PartPredicate.node(" + this.nodePattern + ')';
    }

    public static NodePartPredicate fromValue(Value value) {
        UriPattern nodePattern = UriPattern.parse((String)value.getAttr("node").stringValue());
        return new NodePartPredicate(nodePattern);
    }
}

