/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.LaneRelay;
import swim.runtime.lane.CommandLaneModel;
import swim.runtime.lane.CommandLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.warp.CommandMessage;

final class CommandLaneRelayCommand
extends LaneRelay<CommandLaneModel, CommandLaneView<?>> {
    final Link link;
    final CommandMessage message;
    Form<?> valueForm;
    Object object;

    CommandLaneRelayCommand(CommandLaneModel model, Link link, CommandMessage message) {
        super(model, 3);
        this.link = link;
        this.message = message;
    }

    @Override
    protected boolean runPhase(CommandLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.object = valueForm.cast((Item)this.message.body());
                if (this.object == null) {
                    this.object = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneOnCommand(this.object);
            }
            return view.dispatchOnCommand(this.link, this.object, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((CommandLaneModel)this.model).sendDown(this.message.body());
    }
}

