/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import swim.api.warp.WarpUplink;
import swim.collections.FingerTrieSeq;
import swim.runtime.LaneView;
import swim.runtime.WarpBinding;
import swim.runtime.lane.DemandMapLaneUplink;
import swim.runtime.lane.DemandMapLaneView;
import swim.runtime.warp.WarpLaneModel;
import swim.structure.Record;
import swim.structure.Value;

public class DemandMapLaneModel
extends WarpLaneModel<DemandMapLaneView<?, ?>, DemandMapLaneUplink> {
    @Override
    public String laneType() {
        return "map";
    }

    @Override
    protected DemandMapLaneUplink createWarpUplink(WarpBinding link) {
        return new DemandMapLaneUplink(this, link);
    }

    @Override
    protected void didOpenLaneView(DemandMapLaneView<?, ?> view) {
        view.setLaneBinding(this);
    }

    void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((DemandMapLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    void remove(Value key) {
        this.sendDown((Value)Record.create((int)1).attr("remove", (Value)Record.create((int)1).slot("key", key)));
    }

    Value nextDownCue(Value key, WarpUplink uplink) {
        Object views = this.views;
        if (views instanceof DemandMapLaneView) {
            return ((DemandMapLaneView)views).nextDownCue(key, uplink);
        }
        if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                Value value = ((DemandMapLaneView)viewArray[i]).nextDownCue(key, uplink);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    Iterator<Map.Entry<Value, Value>> syncKeys(WarpUplink uplink) {
        Object views = this.views;
        if (views instanceof DemandMapLaneView) {
            return ((DemandMapLaneView)views).syncKeys(uplink);
        }
        if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                Iterator<Map.Entry<Value, Value>> iterator = ((DemandMapLaneView)viewArray[i]).syncKeys(uplink);
                if (iterator == null) continue;
                return iterator;
            }
        }
        return null;
    }
}

