/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import swim.api.Downlink;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.HostBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.PushRequest;
import swim.runtime.router.HostTable;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class HostTableNode
implements NodeContext {
    protected final HostTable host;
    protected final NodeBinding node;
    protected final Uri nodeUri;

    public HostTableNode(HostTable host, NodeBinding node, Uri nodeUri) {
        this.host = host;
        this.node = node;
        this.nodeUri = nodeUri;
    }

    @Override
    public final HostBinding host() {
        return this.host;
    }

    @Override
    public final NodeBinding nodeWrapper() {
        return this.node.nodeWrapper();
    }

    @Override
    public <T> T unwrapNode(Class<T> nodeClass) {
        if (nodeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public final Uri meshUri() {
        return this.host.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.host.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.host.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public long createdTime() {
        return this.node.createdTime();
    }

    @Override
    public final Identity identity() {
        return null;
    }

    @Override
    public Policy policy() {
        return this.host.policy();
    }

    @Override
    public Schedule schedule() {
        return this.host.schedule();
    }

    @Override
    public Stage stage() {
        return this.host.stage();
    }

    @Override
    public StoreBinding store() {
        return this.host.store();
    }

    @Override
    public LaneBinding createLane(LaneDef laneDef) {
        return this.host.hostContext().createLane(this.nodeUri, laneDef);
    }

    @Override
    public LaneBinding createLane(Uri laneUri) {
        return this.host.hostContext().createLane(this.nodeUri, laneUri);
    }

    @Override
    public LaneBinding injectLane(Uri laneUri, LaneBinding lane) {
        return this.host.hostContext().injectLane(this.nodeUri, laneUri, lane);
    }

    @Override
    public void openLanes(NodeBinding node) {
        this.host.hostContext().openLanes(this.nodeUri, node);
    }

    @Override
    public AgentFactory<?> createAgentFactory(AgentDef agentDef) {
        return this.host.hostContext().createAgentFactory(this.nodeUri, agentDef);
    }

    @Override
    public <A extends Agent> AgentFactory<A> createAgentFactory(Class<? extends A> agentClass) {
        return this.host.hostContext().createAgentFactory(this.nodeUri, agentClass);
    }

    @Override
    public void openAgents(NodeBinding node) {
        this.host.hostContext().openAgents(this.nodeUri, node);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.host.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.host.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.host.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.host.trace(message);
    }

    public void debug(Object message) {
        this.host.debug(message);
    }

    public void info(Object message) {
        this.host.info(message);
    }

    public void warn(Object message) {
        this.host.warn(message);
    }

    public void error(Object message) {
        this.host.error(message);
    }

    @Override
    public void close() {
        this.host.closeNode(this.nodeUri);
    }

    @Override
    public void willOpen() {
    }

    @Override
    public void didOpen() {
    }

    @Override
    public void willLoad() {
    }

    @Override
    public void didLoad() {
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willUnload() {
    }

    @Override
    public void didUnload() {
    }

    @Override
    public void willClose() {
    }
}

