/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import java.util.concurrent.ConcurrentLinkedQueue;
import swim.runtime.warp.ListLinkDelta;
import swim.runtime.warp.WarpDownlinkModel;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Value;
import swim.uri.Uri;

public abstract class ListDownlinkModem<View extends WarpDownlinkView>
extends WarpDownlinkModel<View> {
    final ConcurrentLinkedQueue<ListLinkDelta> upQueue = new ConcurrentLinkedQueue();

    public ListDownlinkModem(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    protected boolean upQueueIsEmpty() {
        return this.upQueue.isEmpty();
    }

    public void queueUp(ListLinkDelta delta) {
        this.upQueue.add(delta);
    }

    public void pushUp(ListLinkDelta delta) {
        int newStatus;
        int oldStatus;
        this.queueUp(delta);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x800) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.linkContext.feedUp();
        }
    }

    @Override
    protected Value nextUpQueue() {
        ListLinkDelta delta = this.upQueue.poll();
        return delta != null ? delta.toValue() : null;
    }
}

