/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import swim.runtime.DownlinkView;
import swim.runtime.warp.WarpDownlinkModem;
import swim.runtime.warp.WarpDownlinkRelayDidLink;
import swim.runtime.warp.WarpDownlinkRelayDidSync;
import swim.runtime.warp.WarpDownlinkRelayDidUnlink;
import swim.runtime.warp.WarpDownlinkRelayOnEvent;
import swim.runtime.warp.WarpDownlinkRelayWillCommand;
import swim.runtime.warp.WarpDownlinkRelayWillLink;
import swim.runtime.warp.WarpDownlinkRelayWillSync;
import swim.runtime.warp.WarpDownlinkRelayWillUnlink;
import swim.runtime.warp.WarpDownlinkView;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class WarpDownlinkModel<View extends WarpDownlinkView>
extends WarpDownlinkModem<View> {
    public WarpDownlinkModel(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    public final boolean keepLinked() {
        Object views = this.views;
        if (views instanceof WarpDownlinkView) {
            return ((WarpDownlinkView)views).keepLinked();
        }
        if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                if (!((WarpDownlinkView)viewArray[i]).keepLinked()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean keepSynced() {
        Object views = this.views;
        if (views instanceof WarpDownlinkView) {
            return ((WarpDownlinkView)views).keepSynced();
        }
        if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                if (!((WarpDownlinkView)viewArray[i]).keepSynced()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void pushDownEvent(EventMessage message) {
        this.onEvent(message);
        new WarpDownlinkRelayOnEvent(this, message).run();
    }

    @Override
    protected void pushDownLinked(LinkedResponse response) {
        this.didLink(response);
        new WarpDownlinkRelayDidLink(this, response).run();
    }

    @Override
    protected void pushDownSynced(SyncedResponse response) {
        this.didSync(response);
        new WarpDownlinkRelayDidSync(this, response).run();
    }

    @Override
    protected void pushDownUnlinked(UnlinkedResponse response) {
        this.didUnlink(response);
        new WarpDownlinkRelayDidUnlink(this, response).run();
    }

    @Override
    protected void pullUpCommand(CommandMessage message) {
        this.onCommand(message);
        new WarpDownlinkRelayWillCommand(this, message).run();
    }

    @Override
    protected void pullUpLink(LinkRequest request) {
        this.willLink(request);
        new WarpDownlinkRelayWillLink(this, request).run();
    }

    @Override
    protected void pullUpSync(SyncRequest request) {
        this.willSync(request);
        new WarpDownlinkRelayWillSync(this, request).run();
    }

    @Override
    protected void pullUpUnlink(UnlinkRequest request) {
        this.willUnlink(request);
        new WarpDownlinkRelayWillUnlink(this, request).run();
    }
}

