/*
 * Decompiled with CFR 0.152.
 */
package swim.io.warp;

import swim.codec.Decoder;
import swim.io.http.HttpClientContext;
import swim.io.http.HttpSettings;
import swim.io.warp.WarpSettings;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpWebSocket;
import swim.io.ws.AbstractWsClient;
import swim.io.ws.WebSocket;
import swim.io.ws.WebSocketContext;
import swim.io.ws.WsSettings;
import swim.io.ws.WsUpgradeRequester;
import swim.warp.Envelope;
import swim.warp.WarpException;
import swim.ws.WsControl;
import swim.ws.WsData;
import swim.ws.WsRequest;

public abstract class AbstractWarpClient
extends AbstractWsClient
implements WebSocketContext<Envelope, Envelope> {
    protected WarpSettings warpSettings;

    public AbstractWarpClient(WarpSettings warpSettings) {
        this.wsSettings = warpSettings.wsSettings();
        this.warpSettings = warpSettings;
    }

    public AbstractWarpClient() {
        this.wsSettings = null;
        this.warpSettings = null;
    }

    public void setHttpClientContext(HttpClientContext context) {
        this.context = context;
        if (this.wsSettings == null) {
            this.wsSettings = WsSettings.from((HttpSettings)context.httpSettings());
            this.warpSettings = WarpSettings.from(this.wsSettings);
        }
    }

    public <I2 extends Envelope> void read(Decoder<I2> content) {
        throw new WarpException("unupgraded websocket");
    }

    public <O2 extends Envelope> void write(WsData<O2> frame) {
        throw new WarpException("unupgraded websocket");
    }

    public <O2 extends Envelope> void write(WsControl<?, O2> frame) {
        throw new WarpException("unupgraded websocket");
    }

    public final WarpSettings warpSettings() {
        return this.warpSettings;
    }

    protected WsUpgradeRequester upgrade(WarpSocket warpSocket, WsRequest wsRequest) {
        WarpWebSocket webSocket = new WarpWebSocket(warpSocket, this.warpSettings);
        warpSocket.setWarpSocketContext(webSocket);
        return new WsUpgradeRequester((WebSocket)webSocket, wsRequest, this.wsSettings);
    }
}

