/*
 * Decompiled with CFR 0.152.
 */
package swim.io.warp;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import swim.codec.Encoder;
import swim.concurrent.ConcurrentTrancheQueue;
import swim.concurrent.PullContext;
import swim.concurrent.PullRequest;
import swim.concurrent.PushRequest;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.IpSocket;
import swim.io.warp.WarpSettings;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpSocketContext;
import swim.io.ws.WebSocket;
import swim.io.ws.WebSocketContext;
import swim.warp.Envelope;
import swim.warp.WarpException;
import swim.ws.WsClose;
import swim.ws.WsControl;
import swim.ws.WsData;
import swim.ws.WsFragment;
import swim.ws.WsFrame;
import swim.ws.WsText;

public class WarpWebSocket
implements WebSocket<Envelope, Envelope>,
WarpSocketContext,
PullContext<Envelope> {
    protected final WarpSocket socket;
    protected final WarpSettings warpSettings;
    final ConcurrentTrancheQueue<PullRequest<Envelope>> supply;
    protected WebSocketContext<Envelope, Envelope> context;
    volatile long status;
    static final long SUPPLY_MAX;
    static final long DEMAND_MAX;
    static final long BUFFER_MAX;
    static final int DEMAND_SHIFT;
    static final int BUFFER_SHIFT;
    static final long SUPPLY_MASK;
    static final long DEMAND_MASK;
    static final long BUFFER_MASK;
    static final long UPGRADED;
    static final long CLOSING;
    static final long TARGET_DEMAND;
    static final int TRANCHES;
    static final AtomicLongFieldUpdater<WarpWebSocket> STATUS;

    public WarpWebSocket(WarpSocket socket, WarpSettings warpSettings) {
        this.socket = socket;
        this.warpSettings = warpSettings;
        this.supply = new ConcurrentTrancheQueue(TRANCHES);
    }

    public WebSocketContext<Envelope, Envelope> webSocketContext() {
        return this.context;
    }

    public void setWebSocketContext(WebSocketContext<Envelope, Envelope> context) {
        this.context = context;
        this.socket.setWarpSocketContext(this);
    }

    public long idleTimeout() {
        return this.socket.idleTimeout();
    }

    public void doRead() {
        this.socket.doRead();
    }

    public void didRead(WsFrame<? extends Envelope> frame) {
        if (frame instanceof WsFragment) {
            WsFragment fragment = (WsFragment)frame;
            this.context.read(fragment.contentDecoder());
        } else {
            if (frame instanceof WsData) {
                this.socket.didRead((Envelope)frame.get());
            } else if (frame instanceof WsControl) {
                this.socket.didRead((WsControl)frame);
            }
            this.context.read(Envelope.decoder());
        }
    }

    public void doWrite() {
        this.socket.doWrite();
        this.generateDemand();
    }

    public void didWrite(WsFrame<? extends Envelope> frame) {
        if (frame instanceof WsData) {
            block4: {
                long oldStatus;
                long oldBuffer;
                long newBuffer;
                while ((newBuffer = (oldBuffer = ((oldStatus = this.status) & BUFFER_MASK) >>> BUFFER_SHIFT) - 1L) >= 0L) {
                    long newStatus = oldStatus & (BUFFER_MASK ^ 0xFFFFFFFFFFFFFFFFL) | newBuffer << BUFFER_SHIFT;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    break block4;
                }
                throw new WarpException("overbuffer");
            }
            this.socket.didWrite((Envelope)frame.get());
        } else if (frame instanceof WsControl) {
            this.socket.didWrite((WsControl)frame);
        }
        this.generateDemand();
    }

    public void didUpgrade(HttpRequest<?> httpRequest, HttpResponse<?> httpResponse) {
        long newStatus;
        long oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | UPGRADED)) {
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            this.socket.didUpgrade(httpRequest, httpResponse);
            this.context.read(Envelope.decoder());
            this.generateDemand();
            break;
        }
    }

    public void willConnect() {
        this.socket.willConnect();
    }

    public void didConnect() {
        this.socket.didConnect();
    }

    public void willSecure() {
        this.socket.willSecure();
    }

    public void didSecure() {
        this.socket.didSecure();
    }

    public void willBecome(IpSocket socket) {
        this.socket.willBecome(socket);
    }

    public void didBecome(IpSocket socket) {
        this.socket.didBecome(socket);
    }

    public void didTimeout() {
        this.socket.didTimeout();
    }

    public void didDisconnect() {
        long newStatus;
        long oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & ((UPGRADED | CLOSING) ^ 0xFFFFFFFFFFFFFFFFL)) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        this.socket.didDisconnect();
        this.close();
    }

    public void didFail(Throwable error) {
        this.socket.didFail(error);
        this.close();
    }

    public boolean isConnected() {
        WebSocketContext<Envelope, Envelope> context = this.context;
        return context != null && context.isConnected();
    }

    public boolean isClient() {
        WebSocketContext<Envelope, Envelope> context = this.context;
        return context != null && context.isClient();
    }

    public boolean isServer() {
        WebSocketContext<Envelope, Envelope> context = this.context;
        return context != null && context.isServer();
    }

    public boolean isSecure() {
        WebSocketContext<Envelope, Envelope> context = this.context;
        return context != null && context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    @Override
    public WarpSettings warpSettings() {
        return this.warpSettings;
    }

    @Override
    public void feed(PullRequest<Envelope> pullRequest) {
        block1: {
            long oldStatus;
            long oldSupply;
            long newSupply;
            while ((newSupply = (oldSupply = (oldStatus = this.status) & SUPPLY_MASK) + 1L) <= SUPPLY_MAX) {
                long newStatus = oldStatus & (SUPPLY_MASK ^ 0xFFFFFFFFFFFFFFFFL) | newSupply;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                break block1;
            }
            throw new WarpException("exceeded maximum supply: " + newSupply);
        }
        this.supply.add(pullRequest, pullRequest.prio());
        this.generateDemand();
    }

    @Override
    public void feed(Envelope envelope, float prio) {
        this.feed((PullRequest<Envelope>)new PushRequest((Object)envelope, prio));
    }

    @Override
    public void feed(Envelope envelope) {
        this.feed(envelope, 0.0f);
    }

    public void push(Envelope envelope) {
        block3: {
            block1: {
                long newBuffer;
                block2: {
                    long newDemand;
                    long newStatus;
                    long oldStatus;
                    do {
                        oldStatus = this.status;
                        long oldDemand = (oldStatus & DEMAND_MASK) >>> DEMAND_SHIFT;
                        long oldBuffer = (oldStatus & BUFFER_MASK) >>> BUFFER_SHIFT;
                        newDemand = oldDemand - 1L;
                        newBuffer = oldBuffer + 1L;
                        if (newDemand < 0L) break block1;
                        if (newBuffer > BUFFER_MAX) break block2;
                    } while (!STATUS.compareAndSet(this, oldStatus, newStatus = oldStatus & ((DEMAND_MASK | BUFFER_MASK) ^ 0xFFFFFFFFFFFFFFFFL) | newDemand << DEMAND_SHIFT | newBuffer << BUFFER_SHIFT));
                    break block3;
                }
                throw new WarpException("exceeded maximum buffer: " + newBuffer);
            }
            throw new WarpException("overdemand");
        }
        this.context.write((WsData)WsText.from((Object)envelope, (Encoder)envelope.reconEncoder()));
    }

    public void skip() {
        block1: {
            long oldStatus;
            long oldDemand;
            long newDemand;
            while ((newDemand = (oldDemand = ((oldStatus = this.status) & DEMAND_MASK) >>> DEMAND_SHIFT) - 1L) >= 0L) {
                long newStatus = oldStatus & (DEMAND_MASK ^ 0xFFFFFFFFFFFFFFFFL) | newDemand << DEMAND_SHIFT;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                break block1;
            }
            throw new WarpException("overdemand");
        }
    }

    protected void generateDemand() {
        block4: {
            block5: {
                long newDemand;
                block0: while (true) {
                    long newSupply;
                    long newStatus;
                    long oldStatus;
                    PullRequest pullRequest = null;
                    do {
                        if (((oldStatus = this.status) & UPGRADED) == 0L) {
                            return;
                        }
                        long oldSupply = oldStatus & SUPPLY_MASK;
                        long oldDemand = (oldStatus & DEMAND_MASK) >>> DEMAND_SHIFT;
                        long oldBuffer = (oldStatus & BUFFER_MASK) >>> BUFFER_SHIFT;
                        if (pullRequest == null && oldSupply > 0L && oldDemand + oldBuffer < TARGET_DEMAND) {
                            pullRequest = (PullRequest)this.supply.poll();
                        }
                        if (pullRequest == null) break block4;
                        newDemand = oldDemand + 1L;
                        newSupply = oldSupply - 1L;
                        if (newSupply < 0L) break block5;
                        if (newDemand > DEMAND_MAX) break block0;
                    } while (!STATUS.compareAndSet(this, oldStatus, newStatus = oldStatus & ((SUPPLY_MASK | DEMAND_MASK) ^ 0xFFFFFFFFFFFFFFFFL) | newSupply | newDemand << DEMAND_SHIFT));
                    pullRequest.pull((PullContext)this);
                    if (newDemand >= TARGET_DEMAND) continue;
                }
                throw new WarpException("exceeded maximum demand: " + newDemand);
            }
            throw new WarpException("oversupply");
        }
    }

    @Override
    public void write(WsControl<?, ? extends Envelope> frame) {
        if (frame instanceof WsClose) {
            long oldStatus;
            while (((oldStatus = this.status) & (UPGRADED | CLOSING)) == UPGRADED) {
                long newStatus = oldStatus | CLOSING;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                this.context.write(frame);
                break;
            }
        } else {
            this.context.write(frame);
        }
    }

    @Override
    public void become(IpSocket socket) {
        this.context.become(socket);
    }

    @Override
    public void close() {
        WebSocketContext<Envelope, Envelope> context = this.context;
        if (context != null) {
            context.close();
        }
    }

    static {
        int tranches;
        int targetDemand;
        int bufferBits;
        int demandBits;
        int supplyBits;
        STATUS = AtomicLongFieldUpdater.newUpdater(WarpWebSocket.class, "status");
        try {
            supplyBits = Integer.parseInt(System.getProperty("swim.warp.supply.bits"));
        }
        catch (NumberFormatException e) {
            supplyBits = 24;
        }
        try {
            demandBits = Integer.parseInt(System.getProperty("swim.warp.demand.bits"));
        }
        catch (NumberFormatException e) {
            demandBits = 12;
        }
        try {
            bufferBits = Integer.parseInt(System.getProperty("swim.warp.buffer.bits"));
        }
        catch (NumberFormatException e) {
            bufferBits = 24;
        }
        if (supplyBits < 0 || demandBits < 0 || bufferBits < 0 || supplyBits + demandBits + bufferBits > 60) {
            throw new ExceptionInInitializerError();
        }
        SUPPLY_MAX = (1L << supplyBits) - 1L;
        DEMAND_MAX = (1L << demandBits) - 1L;
        BUFFER_MAX = (1L << bufferBits) - 1L;
        DEMAND_SHIFT = supplyBits;
        BUFFER_SHIFT = supplyBits + demandBits;
        SUPPLY_MASK = SUPPLY_MAX;
        DEMAND_MASK = DEMAND_MAX << DEMAND_SHIFT;
        BUFFER_MASK = BUFFER_MAX << BUFFER_SHIFT;
        UPGRADED = 0x1000000000000000L;
        CLOSING = 0x2000000000000000L;
        try {
            targetDemand = Integer.parseInt(System.getProperty("swim.warp.demand.target"));
        }
        catch (NumberFormatException e) {
            targetDemand = 32;
        }
        TARGET_DEMAND = targetDemand;
        try {
            tranches = Integer.parseInt(System.getProperty("swim.warp.tranches"));
        }
        catch (NumberFormatException e) {
            tranches = 5;
        }
        TRANCHES = tranches;
    }
}

