/*
 * Decompiled with CFR 0.152.
 */
package swim.cli;

import swim.api.function.DidClose;
import swim.api.warp.WarpDownlink;
import swim.api.warp.function.DidSync;
import swim.api.warp.function.DidUnlink;
import swim.api.warp.function.OnEvent;
import swim.json.Json;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Value;

public class DownlinkLogger
implements OnEvent<Value>,
DidSync,
DidUnlink,
DidClose {
    final WarpDownlink downlink;
    final String format;

    public DownlinkLogger(WarpDownlink downlink, String format) {
        this.downlink = downlink.observe((Object)this);
        this.format = format;
    }

    public void open() {
        this.downlink.open();
    }

    public void close() {
        this.downlink.close();
    }

    protected void log(String string) {
        System.out.println(string);
    }

    public void onEvent(Value value) {
        if ("json".equals(this.format)) {
            this.log(Json.toString((Item)value));
        } else {
            this.log(Recon.toString((Item)value));
        }
    }

    public void didSync() {
    }

    public void didUnlink() {
        System.exit(1);
    }

    public void didClose() {
        System.exit(0);
    }
}

