/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.data.ValueData;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ValueLaneRelaySet;
import swim.runtime.lane.ValueLaneUplink;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class ValueLaneModel
extends LaneModel<ValueLaneView<?>, ValueLaneUplink> {
    protected int flags;
    protected ValueData<Value> data;
    protected Value key;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    ValueLaneModel(int flags) {
        this.flags = flags;
    }

    public ValueLaneModel() {
        this(1);
    }

    @Override
    protected ValueLaneUplink createUplink(LinkBinding link) {
        return new ValueLaneUplink(this, link);
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        super.setLaneContext(laneContext);
        this.openStore();
    }

    protected void openStore() {
        this.data = this.laneContext.data().valueData(this.laneUri().toString()).isResident(this.isResident()).isTransient(this.isTransient());
        this.key = Text.from((String)this.laneContext.laneUri().toString());
    }

    @Override
    protected void didOpenLaneView(ValueLaneView<?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(CommandMessage message) {
        new ValueLaneRelaySet(this, null, message, message.body()).run();
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public ValueLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            for (LaneView aViewArray : (LaneView[])views) {
                ((ValueLaneView)aViewArray).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public ValueLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public ValueLaneModel isSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetSigned(isSigned);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetSigned(isSigned);
            }
        }
        return this;
    }

    public Value get() {
        return (Value)this.data.get();
    }

    public <V> V set(ValueLaneView<V> view, V newObject) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ValueLaneRelaySet relay = new ValueLaneRelaySet(this, null, newValue);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }
}

