/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.InputBuffer;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

final class ByteArrayInput
extends InputBuffer {
    byte[] array;
    int index;
    int limit;
    Object id;
    long offset;
    InputSettings settings;
    boolean isPart;

    ByteArrayInput(byte[] array, int index, int limit, Object id, long offset, InputSettings settings, boolean isPart) {
        this.array = array;
        this.index = index;
        this.limit = limit;
        this.id = id;
        this.offset = offset;
        this.settings = settings;
        this.isPart = isPart;
    }

    ByteArrayInput(byte[] array, int offset, int length) {
        this(array, offset, offset + length, null, 0L, InputSettings.standard(), false);
    }

    @Override
    public boolean isCont() {
        return this.index < this.limit;
    }

    @Override
    public boolean isEmpty() {
        return this.isPart && this.index >= this.limit;
    }

    @Override
    public boolean isDone() {
        return !this.isPart && this.index >= this.limit;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return this.isPart;
    }

    @Override
    public InputBuffer isPart(boolean isPart) {
        this.isPart = isPart;
        return this;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public InputBuffer index(int index) {
        if (0 <= index && index <= this.limit) {
            this.offset += (long)(index - this.index);
            this.index = index;
            return this;
        }
        InputException error = new InputException("invalid index");
        return InputBuffer.error(error, this.id, this.mark(), this.settings);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public InputBuffer limit(int limit) {
        if (0 <= limit && limit <= this.array.length) {
            this.limit = limit;
            return this;
        }
        InputException error = new InputException("invalid limit");
        return InputBuffer.error(error, this.id, this.mark(), this.settings);
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public int remaining() {
        return this.limit - this.index;
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean has(int index) {
        return 0 <= index && index < this.limit;
    }

    @Override
    public int get(int index) {
        if (0 <= index && index < this.limit) {
            return this.array[index] & 0xFF;
        }
        throw new InputException();
    }

    @Override
    public void set(int index, int token) {
        if (0 > index || index >= this.limit) {
            throw new InputException();
        }
        this.array[index] = (byte)token;
    }

    @Override
    public int head() {
        if (this.index < this.limit) {
            return this.array[this.index] & 0xFF;
        }
        throw new InputException();
    }

    @Override
    public InputBuffer step() {
        if (this.index < this.limit) {
            ++this.index;
            ++this.offset;
            return this;
        }
        InputException error = new InputException("invalid step");
        return InputBuffer.error(error, this.id, this.mark(), this.settings);
    }

    @Override
    public InputBuffer step(int offset) {
        int index = this.index + offset;
        if (0 <= index && index <= this.limit) {
            this.index = index;
            this.offset += (long)offset;
            return this;
        }
        InputException error = new InputException("invalid step");
        return InputBuffer.error(error, this.id, this.mark(), this.settings);
    }

    @Override
    public InputBuffer seek(Mark mark) {
        if (mark != null) {
            long index = (long)this.index + (this.offset - mark.offset);
            if (0L <= index && index <= (long)this.limit) {
                this.index = (int)index;
                this.offset = mark.offset;
                return this;
            }
            InputException error = new InputException("invalid seek to " + mark);
            return InputBuffer.error(error, this.id, this.mark(), this.settings);
        }
        this.offset -= (long)this.index;
        this.index = 0;
        return this;
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public InputBuffer id(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public Mark mark() {
        return Mark.at(this.offset, 0, 0);
    }

    @Override
    public InputBuffer mark(Mark mark) {
        this.offset = mark.offset;
        return this;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int line() {
        return 0;
    }

    @Override
    public int column() {
        return 0;
    }

    @Override
    public InputSettings settings() {
        return this.settings;
    }

    @Override
    public InputBuffer settings(InputSettings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public InputBuffer clone() {
        return new ByteArrayInput(this.array, this.index, this.limit, this.id, this.offset, this.settings, this.isPart);
    }
}

