/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.ParserException;

final class ParserError<O>
extends Parser<O> {
    final Throwable error;

    ParserError(Throwable error) {
        this.error = error;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public Parser<O> feed(Input input) {
        return this;
    }

    @Override
    public O bind() {
        if (this.error instanceof Error) {
            throw (Error)this.error;
        }
        if (this.error instanceof RuntimeException) {
            throw (RuntimeException)this.error;
        }
        throw new ParserException(this.error);
    }

    @Override
    public Throwable trap() {
        return this.error;
    }

    @Override
    public <O2> Parser<O2> asError() {
        return this;
    }
}

