/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpMethod
extends HttpPart
implements Debug {
    final String name;
    private static int hashSeed;
    public static final HttpMethod GET;
    public static final HttpMethod HEAD;
    public static final HttpMethod POST;
    public static final HttpMethod PUT;
    public static final HttpMethod DELETE;
    public static final HttpMethod CONNECT;
    public static final HttpMethod OPTIONS;
    public static final HttpMethod TRACE;

    HttpMethod(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.methodWriter(this.name);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeMethod(this.name, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpMethod) {
            HttpMethod that = (HttpMethod)other;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpMethod.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpMethod").write(46);
        output = this.name.equals("GET") || this.name.equals("HEAD") || this.name.equals("POST") || this.name.equals("PUT") || this.name.equals("DELETE") || this.name.equals("CONNECT") || this.name.equals("OPTIONS") || this.name.equals("TRACE") ? output.write(this.name) : output.write("from").write(40).debug((Object)this.name).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpMethod from(String name) {
        if (name.equals("GET")) {
            return GET;
        }
        if (name.equals("HEAD")) {
            return HEAD;
        }
        if (name.equals("POST")) {
            return POST;
        }
        if (name.equals("PUT")) {
            return PUT;
        }
        if (name.equals("DELETE")) {
            return DELETE;
        }
        if (name.equals("CONNECT")) {
            return CONNECT;
        }
        if (name.equals("OPTIONS")) {
            return OPTIONS;
        }
        if (name.equals("TRACE")) {
            return TRACE;
        }
        return new HttpMethod(name);
    }

    public static HttpMethod parseHttp(String string) {
        return Http.standardParser().parseMethodString(string);
    }

    static {
        GET = new HttpMethod("GET");
        HEAD = new HttpMethod("HEAD");
        POST = new HttpMethod("POST");
        PUT = new HttpMethod("PUT");
        DELETE = new HttpMethod("DELETE");
        CONNECT = new HttpMethod("CONNECT");
        OPTIONS = new HttpMethod("OPTIONS");
        TRACE = new HttpMethod("TRACE");
    }
}

