/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.CircleR2;
import swim.math.R2Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class CircleR2Form
extends R2Form<CircleR2> {
    CircleR2Form() {
    }

    public String tag() {
        return "circle";
    }

    public Class<?> type() {
        return CircleR2.class;
    }

    @Override
    public double getXMin(CircleR2 circle) {
        return circle.xMin();
    }

    @Override
    public double getYMin(CircleR2 circle) {
        return circle.yMin();
    }

    @Override
    public double getXMax(CircleR2 circle) {
        return circle.xMax();
    }

    @Override
    public double getYMax(CircleR2 circle) {
        return circle.yMax();
    }

    @Override
    public boolean contains(CircleR2 outer, CircleR2 inner) {
        return outer.contains(inner);
    }

    @Override
    public boolean intersects(CircleR2 s, CircleR2 t) {
        return s.intersects(t);
    }

    public Item mold(CircleR2 circle) {
        if (circle != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)3).item(circle.cx).item(circle.cy).item(circle.r));
        }
        return Item.absent();
    }

    public CircleR2 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            double cx = header.getItem(0).doubleValue(0.0);
            double cy = header.getItem(1).doubleValue(0.0);
            double r = header.getItem(2).doubleValue(0.0);
            return new CircleR2(cx, cy, r);
        }
        return null;
    }
}

